c This program solves the time dependent equations for
c   a 2 state system. The diagonal terms have been rotated
c   out so the equations are for the coefficients c.
c
c The calculations have the amplitude for the E-field be constant
c
c This program uses the leapfrog algorithm
c psi(t+dt) = psi(t-dt) - 2 i H(t) psi(t)
c
      program simple_2state_constE
      implicit real*8 (a-h,o-z)
      complex *16 ceve(2), codd(2), icom, ceve0(2), crotw(2)
c define the complex number i
      icom = dcmplx(0.d0,1.d0)
c define pi
      pi = 2.d0*dasin(1.d0)
c the output will be in whatever is defined as file
      open(unit=20,file='simple_const_2.0_3.0.txt')
c the electric field is assumed proportional to exp(-t^2/tau^2) cos(omega t)
      tau = 0.1d-6
c define Omega
      rabomeg = 2.0*2.d0*pi/1.0d-6
c define omega_0
      omeg0 = 2.d0*pi/1.d-9
c define the detuning
      detun = 3.0/tau
c define omega
      omeg = omeg0 + detun
c definie the general Rabi frequency
      genrab = sqrt(detun*detun + rabomeg*rabomeg)
      
c set the time step (you should check convergence with respect to dt)
      dt = 0.001d0*2.d0*pi/omeg0
c define the starting (tstr) and final time (tfin)
      tstr = 0.d0
      tfin = 3.d0*2.d0*pi/sqrt(detun*detun + rabomeg*rabomeg)
c define the number of steps in the numerical integration
      numtim = nint(((tfin-tstr)/dt))
c initialize the coefficients in the two state calculation
      ceve0(1) = dcmplx(1.d0,0.d0)
      ceve0(2) = dcmplx(0.d0,0.d0)
      ceve(1) = ceve0(1)
      ceve(2) = ceve0(2)
c these initial conditions for codd assume the E-field constant
c   the sequence is getting codd = c(t + dt) and ceve = c(t) by
c   using 2nd order Runge-Kutta to get the codd
      tim = tstr
      fun = rabomeg*dcos(omeg*tim)
      codd(1) = ceve(1)
      codd(2) = ceve(2)
c ceve in the next step is c(t + dt/2)
      ceve(1)=ceve(1)-icom*0.5*dt*fun*exp(-icom*omeg0*tim)*codd(2)
      ceve(2)=ceve(2)-icom*0.5*dt*fun*exp( icom*omeg0*tim)*codd(1)
c codd in the next step is c(t + dt)
      tim = tstr+dt*0.5d0
      fun = rabomeg*dcos(omeg*tim)
      codd(1) = codd(1) - icom*dt*fun*exp(-icom*omeg0*tim)*ceve(2)
      codd(2) = codd(2) - icom*dt*fun*exp( icom*omeg0*tim)*ceve(1)
c set ceve to be c(t)
      ceve(1) = ceve0(1)
      ceve(2) = ceve0(2)
c finished the set up of the coefficients
      
c nmod is roughly how many steps to skip so the number of output points
c    are the denominator
      nmod = numtim/2000
      
c the 10 loop is the time steps
c  because of how the leapfrog algorithm works, the times are stepped in 2's
      do 10 j = 1, numtim, 2
c define the time for step j
      tim = tstr + dfloat(j)*dt
c compute the Omega X F(t) X cos(omega t)
      fun = rabomeg*dcos(omeg*tim)
c step the psi(t - dt)
      ceve(1) = ceve(1) - 2.0d0*icom*dt*fun*
     1    exp(-icom*omeg0*tim)*codd(2)
      ceve(2) = ceve(2) - 2.0d0*icom*dt*fun*
     1    exp( icom*omeg0*tim)*codd(1)

c define the time for step j+1
      tim = tstr + dfloat(j+1)*dt
c compute the Omega X F(t) X cos(omega t)
      fun = rabomeg*dcos(omeg*tim)
c step the psi(t)
      codd(1) = codd(1) - 2.0d0*icom*dt*fun*
     1    exp(-icom*omeg0*tim)*ceve(2)
      codd(2) = codd(2) - 2.0d0*icom*dt*fun*
     1    exp( icom*omeg0*tim)*ceve(1)

c every nmod steps output the populations
      if(mod(j,nmod) .le. 1) then
c write the time in microsecs, P_1, P_2, P_1+P_2 to the screen
      write(6,900)tim*1.e6,abs(ceve(1))**2,abs(ceve(2))**2,
     1  abs(ceve(1))**2+abs(ceve(2))**2
c crotw is the rotating wave approximation to the c
      dmc = dcos(0.5d0*genrab*tim)
      dms = dsin(0.5d0*genrab*tim)
      crotw(1) = ceve0(1)*dcmplx(dmc,-dms*detun/genrab)-
     1           ceve0(2)*icom*rabomeg*dms/genrab
      crotw(2) = ceve0(2)*dcmplx(dmc, dms*detun/genrab)-
     1           ceve0(1)*icom*rabomeg*dms/genrab
c write the timein microsecs, P_1, P_2, P_1+P_2, P_1RW, P_2RW to the output file
      write(20,900)tim*1.e6,abs(ceve(1))**2,abs(ceve(2))**2,
     1  abs(ceve(1))**2+abs(ceve(2))**2,abs(crotw(1))**2,
     1  abs(crotw(2))**2
      end if
 10   continue
c end of time loop
      
c define the format of output
 900  format(8(1pe15.7))
      stop 'end of program'
      end
