c This program solves the time dependent equations for
c   a 2 state system. The diagonal terms have been rotated
c   out so the equations are for the coefficients c.
c
c The equations use the rotating wave approximation for the c
c
c The calculations have a Gaussian envelope for the E-field
c   amplitude
c
c This program uses the leapfrog algorithm
c psi(t+dt) = psi(t-dt) - 2 i H(t) psi(t)
c
      program rotwav_2state_tdepE
      implicit real*8 (a-h,o-z)
      complex *16 ceve(2), codd(2), icom
c define the complex number i
      icom = dcmplx(0.d0,1.d0)
c define pi
      pi = 2.d0*dasin(1.d0)
c the output will be in whatever is defined as file
      open(unit=20,file='rotwav_32.0_3.0.txt')
c the electric field is assumed proportional to exp(-t^2/tau^2) cos(omega t)
      tau = 0.1d-6
c define Omega
      rabomeg = 32.0*2.d0*pi/1.0d-6
c define omega_0
      omeg0 = 2.d0*pi/1.d-10
c define the detuning
      detun = 3.0/tau
c define omega
      omeg = omeg0 + detun
      
c set the time step (you should check convergence with respect to dt)
      dt = 0.001d0*2.d0*pi/sqrt(detun*detun+rabomeg*rabomeg)
c define the starting (tstr) and final time (tfin)
      tstr = -6.d0*tau
      tfin = 6.d0*tau
c define the number of steps in the numerical integration
      numtim = nint(((tfin-tstr)/dt))
c initialize the coefficients in the two state calculation
      ceve(1) = dcmplx(1.d0,0.d0)
      ceve(2) = dcmplx(0.d0,0.d0)
c these initial conditions for codd assume the E-field is 0 at t=0
      codd(1) = ceve(1)
      codd(2) = ceve(2)
      
c nmod is roughly how many steps to skip so the number of output points
c    are the denominator
      nmod = numtim/2000
      
c the 10 loop is the time steps
c  because of how the leapfrog algorithm works, the times are stepped in 2's
      do 10 j = 1, numtim, 2
c define the time for step j
      tim = tstr + dfloat(j)*dt
c compute the Omega X F(t) X cos(omega t)
      fun = rabomeg*exp(-tim*tim/tau/tau)*0.5
c step the psi(t - dt)
      ceve(1) = ceve(1) - 2.0d0*icom*dt*fun*
     1    exp(-icom*(omeg0-omeg)*tim)*codd(2)
      ceve(2) = ceve(2) - 2.0d0*icom*dt*fun*
     1    exp( icom*(omeg0-omeg)*tim)*codd(1)

c define the time for step j+1
      tim = tstr + dfloat(j+1)*dt
c compute the Omega X F(t) X cos(omega t)
      fun = rabomeg*exp(-tim*tim/tau/tau)*0.5
c step the psi(t)
      codd(1) = codd(1) - 2.0d0*icom*dt*fun*
     1    exp(-icom*(omeg0-omeg)*tim)*ceve(2)
      codd(2) = codd(2) - 2.0d0*icom*dt*fun*
     1    exp( icom*(omeg0-omeg)*tim)*ceve(1)

c every nmod steps output the populations
      if(mod(j,nmod) .le. 1) then
c write the time in microsecs, P_1, P_2, P_1+P_2 to the screen
      write(6,900)tim*1.e6,abs(ceve(1))**2,abs(ceve(2))**2,
     1  abs(ceve(1))**2+abs(ceve(2))**2
c write the timein microsecs, P_1, P_2, P_1+P_2 to the output file
      write(20,900)tim*1.e6,abs(ceve(1))**2,abs(ceve(2))**2,
     1  abs(ceve(1))**2+abs(ceve(2))**2
      end if
 10   continue
c end of time loop
      
c define the format of output
 900  format(8(1pe15.7))
      stop 'end of program'
      end
