(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    173325,       3208]
NotebookOptionsPosition[    172496,       3186]
NotebookOutlinePosition[    172907,       3202]
CellTagsIndexPosition[    172864,       3199]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "Notebook", " ", "calculates", " ", "the", " ", "Numerical",
       " ", "solution", " ", "\"\<ceve\>\"", " ", "of", " ", "the", " ", 
      "differntial", " ", "equations", " ", "before", " ", "the", " ", "RWA", 
      " ", "in", " ", "pages", " ", "5"}], "&"}], "6", " ", "of", " ", "Chap",
     " ", "7", " ", "notes"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Created", " ", 
     RowBox[{"by", ":", " ", 
      RowBox[{"AbdALGhaffar", " ", "Amer"}]}]}], ",", " ", 
    RowBox[{"Adapted", " ", 
     RowBox[{"from", ":", " ", 
      RowBox[{
       RowBox[{"Prof", ".", " ", "Robicheaux"}], " ", 
       RowBox[{"c", "++"}], " ", "code"}]}]}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.9137315849740033`*^9, 3.9137317017250977`*^9}, {
  3.913731742335961*^9, 3.9137318648836117`*^9}, {3.913732669641413*^9, 
  3.913732687020756*^9}, {3.9137335501790257`*^9, 3.9137335647143106`*^9}, {
  3.913736728697328*^9, 
  3.9137367386038275`*^9}},ExpressionUUID->"15b68a68-948c-4125-b145-\
4dd6483c9a48"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "This", " ", "part", " ", "compares", " ", "the", " ", "analytic", " ", 
     "answer", " ", "of", " ", "the", " ", "phase", " ", "rotated", " ", 
     "RWA", " ", "solution", " ", "\"\<crotw\>\"", " ", "found", " ", "in", 
     " ", "page", " ", "6", " ", "to", " ", "the", " ", "Numerical", " ", 
     "solution", " ", "When", " ", "the", " ", "amplitude", " ", "of", " ", 
     "the", " ", "E"}], "-", 
    RowBox[{"field", " ", "is", " ", "constant"}]}], "*)"}], "\n", 
  RowBox[{"(*", "Parameters", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Tau]", "=", 
     RowBox[{"0.1", "*", 
      RowBox[{"10", "^", 
       RowBox[{"-", "6"}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"rabomeg", "=", 
     RowBox[{"2.0", "*", "2.0", "*", 
      RowBox[{"\[Pi]", "/", 
       RowBox[{"10", "^", 
        RowBox[{"-", "6"}]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"omeg0", "=", 
     RowBox[{"2.0", "*", 
      RowBox[{"\[Pi]", "/", 
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"detun", "=", 
     RowBox[{"3.0", "/", "\[Tau]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"omeg", "=", 
     RowBox[{"omeg0", "+", "detun"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"genrab", "=", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"detun", "^", "2"}], "+", 
       RowBox[{"rabomeg", "^", "2"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"tstr", "=", "0.0"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"tfin", "=", 
     RowBox[{"3.0", "*", "2.0", "*", 
      RowBox[{"\[Pi]", "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"detun", "^", "2"}], "+", 
         RowBox[{"rabomeg", "^", "2"}]}], "]"}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ceve0", "[", "1", "]"}], " ", "=", " ", "1.0"}], ";", 
    RowBox[{
     RowBox[{"ceve0", "[", "2", "]"}], "=", "0.0"}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Define", " ", "the", " ", "system", " ", "of", " ", "differential", " ", 
     "equations"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", " ", "[", "t_", "]"}], ":=", " ", 
     RowBox[{"rabomeg", " ", "*", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"omeg", " ", "*", " ", "t"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqns", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ceve", "[", "1", "]"}], "'"}], "[", "t", "]"}], "==", 
        RowBox[{
         RowBox[{"-", "I"}], "*", 
         RowBox[{"f", "[", "t", "]"}], "*", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "I"}], "*", 
           RowBox[{"(", "omeg0", ")"}], "*", "t"}], "]"}], "*", 
         RowBox[{
          RowBox[{"ceve", "[", "2", "]"}], "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ceve", "[", "2", "]"}], "'"}], "[", "t", "]"}], "==", 
        RowBox[{
         RowBox[{"-", "I"}], "*", 
         RowBox[{"f", "[", "t", "]"}], "*", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", "*", 
           RowBox[{"(", "omeg0", ")"}], "*", "t"}], "]"}], "*", 
         RowBox[{
          RowBox[{"ceve", "[", "1", "]"}], "[", "t", "]"}]}]}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Define", " ", "crotw", " ", "equations"}], "*)"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"crotw1", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"ceve0", "[", "1", "]"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"0.5", "*", "genrab", "*", "t"}], "]"}], "-", 
         RowBox[{"I", "*", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"0.5", "*", "genrab", "*", "t"}], "]"}], "*", 
          RowBox[{"detun", "/", "genrab"}]}]}], ")"}]}], "-", 
      RowBox[{"I", "*", 
       RowBox[{"ceve0", "[", "2", "]"}], "*", "rabomeg", "*", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"0.5", "*", "genrab", "*", "t"}], "]"}], "/", 
        "genrab"}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"crotw2", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"ceve0", "[", "2", "]"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"0.5", "*", "genrab", "*", "t"}], "]"}], "+", 
         RowBox[{"I", " ", "*", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"0.5", "*", "genrab", "*", "t"}], "]"}], "*", 
          RowBox[{"detun", "/", "genrab"}]}]}], ")"}]}], "-", 
      RowBox[{"I", "*", 
       RowBox[{"ceve0", "[", "1", "]"}], "*", "rabomeg", "*", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"0.5", "*", "genrab", "*", "t"}], "]"}], "/", 
        "genrab"}]}]}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Initial", " ", "conditions"}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"initialConditions", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ceve", "[", "1", "]"}], "[", "tstr", "]"}], "==", 
        RowBox[{"ceve0", "[", "1", "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"ceve", "[", "2", "]"}], "[", "tstr", "]"}], "==", 
        RowBox[{"ceve0", "[", "2", "]"}]}]}], "}"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Solve", " ", "the", " ", "differential", " ", "equations", " ", "using", 
     " ", "NDSolve"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solution", "=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eqns", ",", "initialConditions"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ceve", "[", "1", "]"}], ",", 
         RowBox[{"ceve", "[", "2", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "tstr", ",", "tfin"}], "}"}]}], "]"}]}], ";"}], 
   "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Plot", " ", "the", " ", "solutions"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"ceve", "[", "1", "]"}], "[", "t", "]"}], "]"}], "^", 
            "2"}], "+", 
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"ceve", "[", "2", "]"}], "[", "t", "]"}], "]"}], "^", 
            "2"}]}], ")"}], ",", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"ceve", "[", "1", "]"}], "[", "t", "]"}], "]"}], "^", 
          "2"}], ",", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"ceve", "[", "2", "]"}], "[", "t", "]"}], "]"}], "^", 
          "2"}], ",", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"crotw1", "[", "t", "]"}], "]"}], "^", "2"}], ",", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"crotw2", "[", "t", "]"}], "]"}], "^", "2"}]}], "}"}], "/.",
        " ", "solution"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tstr", ",", "tfin"}], "}"}], ",", 
     RowBox[{"PlotLegends", "->", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Total\>\"", ",", "\"\<P1\>\"", ",", "\"\<P2\>\"", ",", 
        "\"\<|crotw1|^2\>\"", ",", "\"\<|crotw2|^2\>\""}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "->", "\"\<Population vs. Time\>\""}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic", ",", "Automatic", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", "Dashed"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Blue", ",", "Dashed"}], "]"}]}], "}"}]}]}], "]"}], 
   "\n"}]}]], "Input",
 CellChangeTimes->{{3.91372560660598*^9, 3.91372560660598*^9}, {
  3.9137283407746572`*^9, 3.9137283632232857`*^9}, {3.9137290030047674`*^9, 
  3.913729013911523*^9}, {3.913729232071003*^9, 3.913729252946496*^9}, {
  3.9137293505147057`*^9, 3.9137294272027817`*^9}, {3.913729473359588*^9, 
  3.913729504391285*^9}, {3.9137295637208776`*^9, 3.91372956693963*^9}, {
  3.9137303752605305`*^9, 3.9137305945094166`*^9}, {3.913730865064094*^9, 
  3.913730869829717*^9}, {3.9137309769812603`*^9, 3.9137310187391424`*^9}, {
  3.9137310552200994`*^9, 3.9137310753089094`*^9}, {3.9137311186630726`*^9, 
  3.91373116855906*^9}, {3.9137330732368956`*^9, 3.913733093924635*^9}, {
  3.9137335145619106`*^9, 3.9137335223435307`*^9}, {3.913733569910593*^9, 
  3.913733625496788*^9}, {3.913736777921066*^9, 3.9137368690013404`*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"f627302c-8394-461a-8f33-cf60a1f2bf02"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwd0Xkw1HEUAPAl4w+zodpyjUq3q5DK+RhNZh1NJSKjoYj1xw4RDR2qCS3t
zyq1rbCHVMYRm7vWH2pQqiFiiTaijc2SHBupvO+befOdz8x73/dmnsWZuICz
2jQazXEl8W1zuc4bEeu5ty3/W4kpjyfe5ZNSthNcVAmIRebUwWo2E+IGHYij
pra8eXb+JDT8Pf4X3derz537fgbcOzOW0Qd3ZHala1gQG/n8D7qb1fWSnx0H
s/6KJfQm7tyodV8CVIYbEseEq5r9rZLhX5P9Iqkv3ahUslPgUVbwb3R5mbNJ
aMolEEZka9BGj923cFvTIOlt5QJaU56X38G+Bm5uinl0spdlB3f6Ojg2rieW
BTrE2OXdgKP1LnPoJq89N5vNMkBYyp5FX60QMWxfZYKmgPqFDumxa5dHcWBG
VTuDVvbW0OLHsyC+YPwn2uNExUMldQu2d9KJD1cL3vkaU9CW4TGN3sZZPE21
5ABjImIKnakvozKlPGDYpqvJ/63zlbKkXPC+2ziJ5r6Y0InyuQ3MtIEf6EJR
iDnN4A4kUnTiupGg102dd2BTu6cK7Ri5umxMkgc8negJ0t8FR3Rj7sLCR/44
2u+KlSXf9R7oqRu/o9dySu550/nA2atQomuu5beq3vOhMp1B3NTgY6MluQ9g
d+AbumAoIZAeI4AwOmuM7B9hbbh/Vz5sVxSOonstirQ6f+dDoEHLV7RWV1Zt
uOwBCEPnR9C8ZntheG4BtPYYEy8KAvyCgguhpY45jGZ3a2fHmhTBml+Xv6AP
+bFpalURSFMlCnLPqmNOrCohnFvX85nMt9IElHqJwGDn3BCab53TbVsmAkvK
lDhva+S+CroYwp4eHkS/cmFIo5LFMGgW/wk9zNQ2NOoXw4Vo8QB6lW5DvdxZ
AuwweT86eMQ39YNEAhtsl+RoQa3pxjadYnhvupvYM9W9JNG1GNSnZH3obxBh
szmhGMQDPsT/AQs/6RQ=
          "]]}, Annotation[#, "Charting`Private`Tag$6497#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVmnk4VV0Uxn0VCUWiSSSViEqUCGsjRGYp8xAqyph5Sinz7Jqu6V6UJFGm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          "]]}, Annotation[#, "Charting`Private`Tag$6497#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVWnc8lf8XVzLSklAyMrJKSNGgc0pI2ZJVUSipjOw9s7drXfPakpIt23PL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          "]]}, Annotation[#, "Charting`Private`Tag$6497#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          GrayLevel[0], 
          Dashing[{Small, Small}]], 
         LineBox[CompressedData["
1:eJw1m3k4VV8XgKWUKDRoEolIUUmRDGtLETJmJkM0UJHMs5BZpmu6xsvVJGUe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          "]]}, Annotation[#, "Charting`Private`Tag$6497#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1], 
          Dashing[{Small, Small}]], 
         LineBox[CompressedData["
1:eJwVW3c8lf8XVzISDbNlZKWojEjGORJlh+wKUYmyZcvesq51r3VzZUdGke3e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          "]]}, Annotation[#, "Charting`Private`Tag$6497#1"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"Population vs. Time\"", TraditionalForm], 
     PlotRange -> {{0., 5.795301146243947*^-7}, {0., 0.9999999999999944}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Total\"", "\"P1\"", "\"P2\"", "\"|crotw1|^2\"", "\"|crotw2|^2\""}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> RGBColor[0, 0, 1]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.9137330948975754`*^9, 3.913733523431549*^9, 
  3.9137336361858797`*^9, 3.913736813572191*^9, 3.9137369032369213`*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"49fcf7d7-752b-4a2c-a745-7be338f7e704"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "This", " ", "part", " ", "Solves", " ", "for", " ", "the", " ", 
     "probablties", " ", "assuming", " ", "that", " ", "the", " ", 
     "amplitude", " ", "of", " ", "the", " ", "E"}], "-", 
    RowBox[{
    "field", " ", "is", " ", "a", " ", "gaussian", " ", "in", " ", "time"}]}],
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Parameters", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Tau]", "=", 
     RowBox[{"0.1", "*", 
      RowBox[{"10", "^", 
       RowBox[{"-", "6"}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"rabomeg", "=", 
     RowBox[{"32.0", "*", "2.0", "*", 
      RowBox[{"\[Pi]", "/", 
       RowBox[{"10", "^", 
        RowBox[{"-", "6"}]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"omeg0", "=", 
     RowBox[{"2.0", "*", 
      RowBox[{"\[Pi]", "/", 
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"detun", "=", 
     RowBox[{"3.0", "/", "\[Tau]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"omeg", "=", 
     RowBox[{"omeg0", "+", "detun"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"genrab", "=", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"detun", "^", "2"}], "+", 
       RowBox[{"rabomeg", "^", "2"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"tstr", "=", 
     RowBox[{
      RowBox[{"-", "6.0"}], "*", "\[Tau]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"tfin", "=", 
     RowBox[{"6.0", "*", "\[Tau]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ceve0", "[", "1", "]"}], " ", "=", " ", "1.0"}], ";", 
    RowBox[{
     RowBox[{"ceve0", "[", "2", "]"}], "=", "0.0"}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Define", " ", "the", " ", "system", " ", "of", " ", "differential", " ", 
     "equations"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", " ", "[", "t_", "]"}], ":=", " ", 
     RowBox[{"rabomeg", "*", 
      RowBox[{"Exp", "[", 
       FractionBox[
        RowBox[{"-", 
         SuperscriptBox["t", "2"]}], 
        SuperscriptBox["\[Tau]", "2"]], "]"}], "*", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"omeg", " ", "*", " ", "t"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqns", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ceve", "[", "1", "]"}], "'"}], "[", "t", "]"}], "==", 
        RowBox[{
         RowBox[{"-", "I"}], "*", 
         RowBox[{"f", "[", "t", "]"}], "*", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "I"}], "*", 
           RowBox[{"(", "omeg0", ")"}], "*", "t"}], "]"}], "*", 
         RowBox[{
          RowBox[{"ceve", "[", "2", "]"}], "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ceve", "[", "2", "]"}], "'"}], "[", "t", "]"}], "==", 
        RowBox[{
         RowBox[{"-", "I"}], "*", 
         RowBox[{"f", "[", "t", "]"}], "*", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", "*", 
           RowBox[{"(", "omeg0", ")"}], "*", "t"}], "]"}], "*", 
         RowBox[{
          RowBox[{"ceve", "[", "1", "]"}], "[", "t", "]"}]}]}]}], "}"}]}], 
    ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Initial", " ", "conditions"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"initialConditions", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ceve", "[", "1", "]"}], "[", "tstr", "]"}], "==", 
        RowBox[{"ceve0", "[", "1", "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"ceve", "[", "2", "]"}], "[", "tstr", "]"}], "==", 
        RowBox[{"ceve0", "[", "2", "]"}]}]}], "}"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Solve", " ", "the", " ", "differential", " ", "equations", " ", "using", 
     " ", "NDSolve"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solution", "=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eqns", ",", "initialConditions"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ceve", "[", "1", "]"}], ",", 
         RowBox[{"ceve", "[", "2", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "tstr", ",", "tfin"}], "}"}]}], "]"}]}], ";"}], 
   "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Plot", " ", "the", " ", "solutions"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"ceve", "[", "1", "]"}], "[", "t", "]"}], "]"}], "^", 
            "2"}], "+", 
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"ceve", "[", "2", "]"}], "[", "t", "]"}], "]"}], "^", 
            "2"}]}], ")"}], ",", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"ceve", "[", "1", "]"}], "[", "t", "]"}], "]"}], "^", 
          "2"}], ",", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"ceve", "[", "2", "]"}], "[", "t", "]"}], "]"}], "^", 
          "2"}]}], "}"}], "/.", " ", "solution"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tstr", ",", "tfin"}], "}"}], ",", 
     RowBox[{"PlotLegends", "->", 
      RowBox[{"{", 
       RowBox[{"\"\<Total\>\"", ",", "\"\<P1\>\"", ",", "\"\<P2\>\""}], 
       "}"}]}], ",", 
     RowBox[{"PlotLabel", "->", "\"\<Population vs. Time\>\""}]}], "]"}], 
   "\n"}]}]], "Input",
 CellChangeTimes->{{3.913732930097823*^9, 3.9137330599110875`*^9}, 
   3.9137330989495916`*^9, {3.9137331642821565`*^9, 3.913733216754059*^9}, {
   3.9137334041114655`*^9, 3.9137334379555764`*^9}, {3.9137334956824927`*^9, 
   3.9137335032132177`*^9}, {3.9137336406899824`*^9, 
   3.9137337394840927`*^9}, {3.9137369095459642`*^9, 3.913736931662084*^9}, 
   3.9144050979280252`*^9},ExpressionUUID->"8e7b013f-2da2-4569-9a5c-\
62d0cf16fbc0"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJxF1ns41FkfAPCxRHpHSLIhsbmkZKz1ouJo5ZLb5vKmmlSWbL2ozJgxE+Y1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          "]]}, Annotation[#, "Charting`Private`Tag$7132#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJxE13c819//P35ESkbKqBDKLGWTdY7KiCQrSUL2yt47e4+nGRIKJUpGZBwr
GZVQ9t77SUlGqt/j8fr8Lu+vf1yulwuP83iccz+3cz+cJg5a5mQkJCS55CQk
+G8PfoX5Lc5niOS/nw3oZN6d/rHu6f9sm2twPff2/zPPpY/9yr55/3Nl3u8k
j9e5/zN65vrt5XzO/xzXelVmhPr/2dT1RSFvcPb/fCnTgzu+M+t/ZlUqtFT+
kYmI//CfdUj6vf/Fv5OZqOL/d41DO9tljQzU/ef/7Ex8lxgU9giJbfyfv0eT
CjS8TEdcgf9nR36VD7+709C88J//3JKhRWgiT0MFgmv/mYnawDD8Uioat3nz
n2cYXpVoOqYg+6NZf3GXspH8YXmejBhcX+/iTuG10f/slIwsr4b9wu0t/K3K
XyYZNfcPfMdtJxFpcZsjGYlQ4Z+wDo1kAKMQRTIaY/u1jHuwPt0uazsJJTs0
LuLWkt9sObSchBaodedxf2y+weI2moTq2itncCsoPnee6kpCize/TuKubyPr
vNGUhDrss8dwS6je46wpT0JSvrTDuF2iqW5sFCchgyGuwf/e/1OVJ09BEpJn
5OnHzX/zWDchPQmNvVzowW2R0PC7PTEJzbPnf8Gd12PH+y8qCZ1OV/qMm1Wn
zd/WLwlpbfO049ZLcS3KdU9CX5yMW/+bj37O/gGHJHSRy7UZN+0d3wsKJklo
lutiHW7VDP473neT0DXlgWrc4SP9IaU6SWh/7l4lbhJD4VFW5STUMrtdglvu
yTiltnwSct8gKfpvfiejRSOlsPGzv+Xj3jSZj9o6n4QYBTqzcAs9S3p7njsJ
vfZfSvtv/ufkp++fTkLME58JuOctM6W6jiah3UpiOO4zL66Zk1MloS7p80H/
rc/yVoL0gST0nua873/rY6exWLBFQDGHNRxwl9dF39NcJyC6vjgr3HHUbb2/
FwmoHB00wa1YLFevMUpADoPG2rg59j1FfvcR0BcVcjXc+9crCvO/EFBJWNVV
3GUr5wh7zQQ0dGZJBHesjAVlfh0Badk68eO2is71vfmWgLxCbnLgZj9/wvLZ
CwIaJbYdwb3nrT2q/pSAxvXdSHH3d8Zp7mYRkOzUl62/mGNsKGTVEwgosFx9
HLdljfybnUgC8jt3ogf3FSpfnqfBBFSdfe897t0XP47uuGPj15cX4v62eyEs
z5GAhDsVH+EuVbH+rWZDQEdoSCJxWyxNzOXeI6AHdXJWuC9LsdxVu01ABzTG
buFmjdTt/qWBzc+qoALur3yfa64rENA5iZusuOWtauK3zhGQUCv1+z+YWaq3
yHO4CKigLasI9y9KYW/V0wT0seQ0AXdJYaHZE3oCumI+po87Ynt6SOUIAR2K
Xwe4zZRP3/xJTkBukxHsuE8tJEup7CSiWOuIyX3MWxLdrza/J6Krih71uLvD
jnBlrySiAWJOJu5wniDazfFERGl69ybun+YOM1mtiWil26TgN+YvlUV6yg2J
yO6AnDvuIor5z9+rE9GxX6XKuO/nG1QrFScim140vodZdivtwvf8RDSVYfIC
9wnFr3mZTxKR7kn0AHfXrErsBiERBavJ/NrF/EIslCwzJhHNX75RgTskpNFD
MSwRlXPdd8UtzSVpkuGViC5rPJrdwVxoyiWpYJyIFNmK8rcxe5oRQi3uYN/r
LamEW9Wc5FuEViJaevx8+hfmVYtRx88KiYheNIgWN7JUbViXS0Rj/PGPtzDH
W1XTHJNMRHfpW3lxi9gkF+nyJ6Jx9ymBn5jJbcl2Pc9gz+vTL9zE3GfrqJzJ
kohkInlYcXs+UJudoElEsoENm9/x5zuSn7b+kYCKf8xpr2NOcHK2i15JQOW/
xh8R8flynqwpmU1A4dOUg2v4813rbv/oT0C1Q49lVvF6dj1XwNCdgIzTjI1X
8O91S/8p0ZGAnnr99lnGv8/DNdGnNgGxmiqmLuL15jk98bgiAQ385EtewLzm
qXGxsSQBqevcDp/Hx/cW+Eiek4C0341cn8Xf32+WPC4kARllBctPYC7w19Iu
9UtAd94PjYzh3xPQmNvrnoA2HydbjeL19DALMFsnILrmBe0hfD4fUsVKmSSg
1Y8qbwbwPA7yHLl7NwF15zz904fZOETHM+dGAqoKSjDuxecztPlDs1IC0vOq
c+vGfCBMiHEOJiDfDHqPLnz8cOoyfpEEJPiRTaYTf37U+5UyJuz/v5m+acTn
M1pEuo8uAU30vDqK8PWKyYnYPpSAVni4btXi9c+6q+r5Kx51kNtFVmKmPN23
ULcYjxpiGD3K8HplfxNCOhKPUppSFV9j3jhjjaIa4lEo0SDwOeYkLsW7X97E
I453XMvP8POEh3Pn+LN4VMXYIZiL2Zd/SPhxRDzyrj2v8gh/vpBK/mvNeLQ0
JxUdjudp7Z0oMYV4lKr6syYIr38lG4d3EvFoggm88MPPZ4NoqRaWeFT6RZzK
Bc+nhczT12jjUfOJyMQH+Po6Fx/4TBKPZhg6ly0xj0Z8/tw/F4f6NVrL7uJ5
cHy87O5gHKIRucB2CzP9E2LaZGccGp+i0lHHrFRJZ7L8Og6Vf8/Tl8fzakrz
1x+vOOSXVf2YA3OnnclIkF0cyjk3NMOMeW7buZHSKA7tcukdoMPXlzY5il4h
DvG1fbDa/7sOxR49c0iViENfkgeNfmC+yVWpw8Ifh6ql9L4sYA6R7j/NTRuH
CPRqr3owZ7fOHygiiUNnGC+qf8D8TmN78eJmLDrS+yulBjPR4kT5pcFYdJxr
SCMXs16SvrJaXix63244aoXZ+bStQE9yLBJqaem8gzn2hQ+9bngsGhnJW1fB
3NyQNWJkF4sOjZk28WIeVS1pnDWMRcxitycYMW/31edba8Yiv2/BFQcwC6yO
O7hIxKL201mtY3+w+fFY19nhi0VzGqv3OjDfJyOR9mOJRae3DWbLMaee4CQP
J4lFf+mZVsIwkyiapmd0xiAdZl1+bsynul382OtjkEDM3rvDmMXvhpg8ex2D
1BbNXdf216GNU77Aq+QYNKRx3aMcc8h+Jb1oeAxyi9e9koL5SfiHX1VeMWje
7V6kG+ZvjxcamwxjEIHXX1QYM5FvJ19JMwYd+bviSoP5cMWh6I9XY5CQ6keh
pd/rEHTy3+rji0H2vF/qH2N+8ct2afFHNPZ+7LHf97D3fZJ+X3c+Gp2aXO1s
w6yn3DrUMhSNbsvX7mViPpR+ujO7MRpNy+t+l8NsLH/9CnVFNOI/vKRMi7l6
0aPGqzAa0faBtqFd7LyU6inSiYtGEv5Hmpwxo6k/Z5ofRqMfJHrKUpiZos5l
CrpFI/un8/kkmD8MB0dTGUSjVuMXdyN31iG3r4RdI380Wpk2UgnexvYPl+ns
BbZoNNTydhpi/vYp3iDzaDSqrDGM2vqFzRfbkpr7dhS6+VHrnBHm0VbG1pnl
KETOIe9Oi1nM/oqc5ngUYva/QlqzhfWnKPOCQGsUqhUQzaLHLG3Znv+oOgoJ
HXIorPi5Dgl0W2yUxVHI0nWj5S7mK8bqtNOEKER6t28zdXMd5pKSrqcZR6Gk
jwusm9/X4c6LC5YUOlGohI2dKQSzhpb+hLNyFKrvjVw+jJnkafmXGxej0Aff
T7unNrB+ScGi9MB+JJr4ubr4b20dvl0l8DmtRyL9bbNWB8y0KQ0549ORyJg2
5/z0KjZ/cycS33VEolD33PCClXXIFv7RySEtEt0NjDehXlqHroI7S6NRkahg
I3FdZ3EdfhrgMlH1j0RhB5q0Uxaw+ePz1+I2j0RCpulqJ+bX4UiHkOiISCSi
/N5s0jKN5avzvZfXeCKRHc0r3sWpdRh1Kurs25ORSM9oyZIMs7TtzPFEkkjU
cjx5mnliHT6iTv2p1BWBnH4NT/4ZXofjTHzszxoj0ByTzY/OISzPOGtUSMsj
kEP00NPYQSw/xceza9MiUOXjWcbNPuz+YcijInQ/AunfNzkEu9fhX6tql1jt
CGSh2g6ru7D5dlHNXlaMQJOKOud4P2P9fLj95rNzESjNWqJ/tgNb39K3j0/+
DEdyzweXPjVj/WLttXb3+XBkb2ErMtOI5Xnr8I+vg+Eo1pMQvYSw82zor3Jc
fTgCOmWu72uw8ciUf5CFhyNTZgHFN2+w8WiGWI29wpGMK3Hw6ut1GMZsq1xv
G45IrzglfCjG1kMgPstDIxx9jpItyizE+slbA0qrJ8MRE0Hmvn0WNp6RtZMK
dTjSfKb01f7ROnxu/Tuz4G8YIsv1zbydivXX/uzfjWfC0KHubLLxeKx/K7TM
7CsOQ4ar+Z8qHmL1+2a3VeRJGFLNEvFd8VuH7bXRG/GJYajdt/ffYe91qNn9
WlHVPQwdyQyk+ue0Dk12t9cRDENy1f++lRtj59+BqFOsImFI+NHsLpPBOlym
YVX04gpDaSSJYnq3sfvMGfkM0cNhSLwv5MqDG9h41yMUnveGIk/zjOPtkth4
t045ULSGos2Zrzr/hNchtXHxI5OqULTaeUX6mMA6THbtJrJmhSJVpzrSLvZ1
mP/4xKNE81Bkk7A9n0ixDnlaP+gO6IWiPpKm4xt/ifD5qisDm1oo+vx1rdV3
hwiLZHrin4uEogon8eZHy0RYOhQZ1vAvBCW72Z30+kSEIqSXFCg2QxB8dvU6
eSsRlvPNk16fD0G8+bmRqXVE+Nbjil//pxCUPRI5zVtMhHWMv13WHoUg7flg
2sQIIgRyL4RFY0OQL/eZtT/+RNhgdnvdMzAE1Tk1SMi5EWFzebkNuWUI4mPr
FxO6T4Rtmnb3WcRCUKJkhLywJBFe8zrFfp83BEV/tdH2PU+EnTntowWnQpCf
u/avFxxE+GmdS0+ENARdUxur/nSICHtjx9RVuoIR3+fI8uP9a1CnMpo6vikY
Td91sDLtWIN9o1Kd3yqC0Sj3A8+C2jU4eD5V0TgzGN1it83hy1mDYx3qsh5W
wYjXzIE52mwNGn7f3627G4zypFSCDG6twckTL6vIbgaj0Oj2Jx8U1uC0JaVo
nHgweqf5+5cc1xpcpGjkzycLRuFtGjmbE6vQ5oL9wvJWEIpcq9/69mkVruiw
5gstBaGm1ieIr3YVEp96ctR9CUIVz+b0c5JX4c/Lwsxfs4KQ30aNfqTCKvzn
l0dOKhmEbv6kI7ASVqAd5VtXCf4gNC3FwXvRcwUOJ3TM2rIEIaNy+k9d91bg
26cb7/v/PUT21yPuvOVdgfYdILS4/SG6fKBWf6FyGY4yjFDo6T9EuY9+35ep
WYKq2US3WLWHiJPaRtk5fQlW85LNN4OHyPZA2hke9yWYLM3/4cLZh4jt4rEP
R4SW4HVjj7ADq4Eo9InVh+PZi7Dm5XHK136BaOeKb0On+QLkE+f1mHUIRO42
4t/p5RZgKpJeOGkSiHQgrTsJwwJ06rnfFqIUiDJYzsKhxnnIt/06XJ8uELEP
673LZJqHF0PTj1JfCUB/+wf7D1XMwqWyw8drIvzQZ/0R1qSpKVgx+Cg4/4Ef
mtvb8+KqmoL+f/l/Jmj5obczR8gZ4qYgg6pqnyWrH/ISa9/gAVNQfioqjbHU
F9GfyYv/mjUJj1CyHCJN8UWiF5/eUXSfhP0CLz1XvXyR/oBoTozmJLTz/Hin
5aovGioMfpBAPQnT6ahZnQZ80JH0AEIw9QQ0Fc+KMajzQXde3Wsg/zwOL94V
+KOc64MYbpHRdyeOw/cFauOnbX2Q/EeL+gS+cRj/aVSdSsMHpSvqDfPvjEH9
H3YNW2I+qE5/+2lO+xhcl4vN+fTXG0mUi9Rp2o7BGlM2+uoZb2Sv5tn0HY7B
kMiSh0/bvdHO39ZfbCfH4M3Xcj/iSrxRX58k58z2KDzV99nEm+CNqs56jB4e
HYVze/e+mnt4o6JaEYL0+1FYykG8qmngjW5z0jBWvxqFPkr+FbKXvdGdzbQM
rYxRqGRHy83H440u3ZoTYggfhfSE7JTjR7xRvl9P3HX3UThadfHgv3UvVLfS
Y7pmPQoLx5D78jcvFDveEpVpOgqdD9xc6HvnhR6MSil9xSzHP3G7KdsLbX76
fvAN9veHbjq0Fwd7ocRE4V4bl1H41fXfpXQrL5QbNNCmEDAKszPiXwTf8EKy
tDD7YcwotG5kP+Ug4oX2NcISujNHodj86yh9Zi8UduHSib/Y+/87Iv9bcd8T
Bd4UIdC0j8JO4W5b4SlPJHKV+oXw4ihMuW08yvrBE736MlZ5gW4MGvttqB16
6Yn6i5qeu8iMwa32oxcnXD0R6RJ3Kk/WGGwk5mR33vFERvtq1sSuMRjFIEz3
FniixvzGH+nk4/CWdFNA7llPlHzk6y0IxyGHseZGzCHseQlz6sWB43AldMrY
c80DcY1bUlp3jMO3L516THs90KGjLtoPTkxAte3EMuksD5S/vSI90jgBmdnO
nOV56IF+ntEkjzwyCaevlCXRW3igAflQJxPJSegZ1+u6KOiBFL7K7DCkTMKr
FSZzXxk80MuD+4IF7ZOQdvjHrYZdd2R+SO6xy79J+Iz7uGRqizsScjvCNOs8
BZdDRz5rFbmje9cpuG8/nYKC80/N6BLd0c/G1Kdh41OwpkCMEGHojvhnrWwO
3JiGX3h117x33VCT6tYPZYUZuMf/6KmRoBuqcXh1bwzMQfmo+9KsTG5IsySf
vTdwDoYu8/cM7rsiy4qg+a81c/Doy5q/mp2uiHjZ8eRhuXnILTB6R8HcFTWn
2fNLnF+ANjHPNkjUXFGNfK3zHZsFWLpqF14v4or0FAN/uj9egFtq4qe9T7qi
693mVtnfFqB0yZ8KCRJXFEVRuR9LswgDaT5c35x3Qcf++H3Il16ErQ/ipl9/
dkGtSd7Ha+0XocZF9qP8mS7IdsfRR/vDIkyNWyiYe+iCFPX/CRtvLcIR4mu5
PCsX9DLjC8ccyxLkuOn5zfCmC3pXJl30TXYJWryWt2WRcEFKZz64BZgtwZd0
h8kGWV1QjJkF717AEtxw6ElPPuCCzremPAnJWIIS3Y8ENZedUWTgeNGt6iXo
I2TygabHGTVpDWa7tS/BxoRz9zqrnNFNsbmkyZElePD7j82wbGeUJ9/DnbaG
5admbdTVUGekpRlV+PjHEkx4E8xJYueMHnl8lHr1Zwn206tV12k5o75Wjpcp
pMuQxZnhppeUM6L7LePJsr8EjXtH58Q5nJHP8QrR89jfF4jk+/44iI2Xq+pn
gD1vlfDg+Os1J9TWkX338MwSFN4UL7L95oSuCS0Gyg8uQXftv/J8tU6I9xxN
SBNagnXlHwZmc50Q04z13UMFS5CUId4+N8IJcRXvHqqIXYJKrrcpDB2cUIar
komdxRKM+caedUrXCYWkcboYKSzBHrFFkQFZJzRhv/ZXg20JMqWUdiSddULL
rPwOA0uL0GDL01iDygnR/20/dQYtwtxbl7epvzuiC6zknGQRi3C+8nBcx4Aj
irF6yXdTdREKMPVi3ZEj2mM9aHqHYRE6uWfUXsl3RPJL3vwjXxbgvsT5pVpn
R6RKznaBX2UBnrqLZm/fdkRRy6s7zDvz8FKA5uSmjCPqbxkCmk/noVubx8B5
CkfUNfnna9D6HBx9HREtKeiAKEK6nx+3mIUndl4FOezYo66citumf2fgLfk+
r8Ime5QxLFMrlTIDu7o5rZh17JEII3BZaZiGjd9rFLY9HyDg++gzF8MU3Jea
khG88gAFjvqOqL2chFJBlKKWRx4g5bnwztMKk7DsmA7nwGM7NCaje69rZxwS
9b1P0FnaIctvT7XuSY3D809z6JSF7BALYNQIChyDz0TX/rxttkX0+TNUBdyj
cNLn+BYx2hY9P6r8hDN0BLK9l1rluWWLFIK8Cs8Rh6E+tfGM4WlbNFHbBe3u
D8NUnbDh1AUblHR0XzViYgj2ZhX3dJXaIKaIsQ0m6yFIN9fbftDbBv019ztZ
8HcQql3YbQBXbZA1483e6pxBGOHGXuVObYOGjxqRtd0chO/rFV+96rNGUPRL
lyz1ICQ9aJc/n22Njn3SD/TuH4BAnZB12soaBUW6/fr6agB6p1Yn6Qpbo1Uj
LcmElAH4dnw8Km7PCgVI97ouRQ3ATR6KoA8tViivjOwsdfwAFHI47/U3xgqJ
X9rtZ8obgHZVmo4SulYodCh37eT7Afj8n4elPbsVujkYlci0NQDnlLMNCxYt
UfTPJ+/+ig3CMwnvb42/sUR8fT23KoIHoeHgshqTjyWKs9F7cmhqEGZw0Cuo
K1gi6aux87VqQ3DASlImjMYSfVL+/sr3wxBkeHNPBPVboNW6XZOFG8NQYzeY
/9cTC1TSPjIdOj0MYy4XcVy0tkCqdSfPfQkegR2R3cwWIhYox5Vclld4FF45
xXaw/7050nWPYRMrGYP+Jlf/0MSZI1YBbTkt73FYW2T9U/G2OUqwW9TX0piA
YjJvpyuXzJCobu9ecOQkdAweHVorM0Ofl2K9uv5OwpKPZD3cvmao/JL4no37
FOQxuNmQQmuGxLIqYoRspiGz32Kmm6gpur1Rb8SqNQuvSQdM3CQxRXnOuTZs
TbPQe5vx7LnPJuiUzOqN8otYvTtdLRq3MEGSbdWH8v7OQVrB4bVqURP0lVnb
7dOteQhXHYWTSEzQ+O568mLdPMyzyK5WzriPLs1WWqdi/dy3s+L7nJb3EcML
pqqSlwuQYuoj3Be9jzYpBOK7txagRLZJcD/JfWQQ8XL/oPgitLq7+6H0szHK
Uj/OG2m7CB+dSKCKzjBGpF/m3jrkLcLOPh51c0tjVNkgp3K6dRHuE+oToZgx
yjkl+8x3YxFe0NDpO0lqjBaEY74fJV2C9af6hRczjZDloerD7axYfqcceJcl
boR4zG5JL2N5E0QnLK/5xRDZnzhYfIxnCc5FGrZRWBuitPZDz1RPLcFr5DHq
NWSG6PyU2mE56iVY5P+uzz7rHpYnd5KOY+cDze68wVmJe+iEkk4DT/cidHRh
mB34YoBE83amnpQswq9rl21jrA3Q0ZrMBC+XRShh5fBD/oAB2iLqURxWwL5v
OstrK+suSjaTC7m/g+WTQSdJkcRd1Pwi1dj13QI0GtgON+zWRxwJpg6y9xdg
syY33XEbfdR+2+7kraMLMFwpkM338R3EODnyIkBtHi43ljwTkryDJAvgdYrF
OagmM3J+rlsP8bVp+hKd5+AxIQlpdXI9dITG/7Vo5CzMPrmqy2Gri6Y49o7e
zZiGpMknx7+R66J/9rP2hSzT0IxW2Twy+xZipB9SXXs8BfkP5Ln86NFBb3eM
9/fzJmHF6u2E95e0UV/FcBh3yBhktgxl9urVQnJ7c58Fskah91RZ9gU7LUR4
bEot2zUCR+9Ock9TaKHkkufoJs0IhP00JalPNFHVwItDBUrDME9DRuy6lCaa
1yAve/NqCJJ/tKr916uBMs3OfmLdG4SWiqlXKuw0UITL448CoYOws6Glw+qg
BuKn23S48GMA6rtO50rL30T3Cnd8hdIGILu1XOlTF3XEmZXnsyw6AGfvpSPq
whuo4UmJ3OJqPyzS2vzkNqyGbgjNySg39kNHZfWRcRo1xEZ73qQ1rh9KyL5Y
Ur58HXXUx3+bS+mH+0LkO6WuqkgEpp1kCO6HTdxGB089V0EDdRpVd8r7IUkZ
WXr4xDXknDxXBvr6oTwo4N9iuoYoosydiskHYGCnSq2JujLWBHvdmzAfgI26
a2rdoUqo8ZoHGc+nAUgykzAuV6+IwliYTzCeH4TQQczx5U8FRNblXZ5SOQj9
fw+QnhRQQIty2iof7wxBFO6TFGZ6Ff36OZCRvToE/x5n5/6ZcQU9+GrcNZE6
DOVymt/e772MlD+VPrKzGYG+AhbXvhy+jAIv+vFwYflTV314WPayPLr8TUBo
bmsU7kTqD+h8B0jJ7Bi55PwY9MjL3RM0lkOTgM5bemgcun8VvDwvJ41Y9AUz
2vUm4daKu1lT8SWUY3ylGk1OQldyFJ7FIolmD5hIt9yZgi7ial1au6KIM96S
7IXJNPxxI+n7BSsR5MVScaJjeho6WwwzHB4QQjnW3W0n9Gfg1MWet/7W59F1
4XXKO/dn4aSR0R8xZT6UL/mnLKt7Fo4nrF1d4eJGp4KNHv5TnoNjTT5RuWRn
0Dlp7ld9TXOwau543utGNiRgI1PvzzMPK5SFBFl9mdErVc+Sk5HzsOyFWl2E
JD0yutZ6deXHPDRk7iUsz1Eg7aaTVC+xfqD0LaN++Lsf9bxJNZpHkxegHcVM
60nTITmiYtcVnvkFaCFFKcdg+09ua61caeTcIqweVCV/A6gB9fo2v8/dRWhE
dXhrxZQBCNPOWMOERWjyfNUy4PkpsLye8yUB619Ezlo9iHTnAIyDeW2H+hah
2I8hnq/pZ4EgRxa/OdbviDddn2St5QH5wULhsX+wvEiof2Qxxg9YqR9IaOwt
wktGgtql/wRA6qrCVubaImRN0zj456gQOJbi93V3dhE+9j88w5knDPrNhT5K
dSzC0xbNDUqiokAlVCnn2ONFmH3DJ8v2vRgoOeh4ysF9EbKLi3kl3JIA224m
Bv+uLsIc1rVblfOSgIsngPTi/gLkJC8QGfaQAhWWpflbVQswb8WQ7t8hGeCr
yn5hy3EBnvnKvHo2Qxbc02ZaPXd8AT6t6W6/dh4AutA/ET3l85ArLzL/QR0E
/7T9Ym/oz8NeBc7LHQXygKhNVeC4Nge1BYbZiJJXQHPlpvcIzRxkyJGICSS5
CoZ2k42G0mfht+NJe8c6roLR7PT6aoZZqPP7+oCkviJQvjibc4F7Bup21ic8
9L0GLAo6uN3Yp6AG+/vBE7oqwCj3YXzPo0mo4trJUSqoCkT4Im93MU5C2dMD
pePT1wH4HXP0IXa/FncZ23GrUwNNt0vOkAiPwYvtM/I0qTdA/i+64N6ro5CP
bTnimYM6CPvwgYXPbARyOm90y6jcBH3k46r/kodhrKlPjDW9BtBJ2yEtHhyC
VHH+QuL+GiCjf44mTGgIhlU//EayogEupgnH9GUNwgMzIZ6fbmsCmg67JwfY
BrH7SQRr+ntN4OGlYUtWOgD3JaMbTYW1wFj/6nqXzgD0MokzE8zWAm5vlO4v
UA3AXzGJh35TaYNjy8U6yb390KUqufiDhzYo2vUsWy/uhxtTaRqEWW3gJjL1
tSCzH9pRZ/68p6kDWA5cVY7M6YdLEtnp/EgHJBRMUVLU90OL+7myW+duAduF
R4GV3/vhdPSzyca0WyCfmHKNGwxAo7eFITHkuoBa1tfnW84AHJ0s4tNz0gXi
j+0+PmQehHeOvPp0dlwXeF0Q6Mp5Mgj7xd84rqveBpzgjuioxBDUMq5gqK26
DdZ6KnoCRobgl6iq6jAuPeDSMW5YEjMM1SprDLQS9cD0wGFRddUR2D5RT3L6
rx746ypi0M4wCpvF3l+rHLgDUs3PEJ71jEFo1LYaqKAP5NlI6NVbxmFdZGeC
2ht9YGB3c228YQJWjncPzkTdBUwgoOfRwiR8HjFmdQzcAw/Lk2y9fk9D7vJJ
6vGie8CFcbjgt88MzBubKX3BbAja/6UbCu3NwEyR5R3574bgaLZ8f/E61t/f
W8uiNjQCt97MXIu0mIPJ4Rvyg51G4BXXpvbR4TmobO/zXlLLGBx5mXFcFav3
sAN+qY8jjMGFmrNl75kW4Pt0f6sDDcbgoVTJTIvzAiS7GChtvWUMWEWF7f0/
LED5lofUX87fB89m7PM96Behv17wuJjJfVA1xrcXqL0I69dCSjPS74PCJ8P8
JTFYvxMUFkTy5T64l3DGRap+EUqfiNCxoDABPmxaQc5zi9CzJJLnk4wJYBmt
/ZBBsQSrrkTvCDubgHVPa/IBrN/5NRDTmfbcBJQNxpzkurgExR7EZf0ZNwEk
XG8ndCWWoDNZgr0poyloLSfz48ZcmpYo33HdFEhEPbp66cISJAokHRMMMgX0
tXZ8ELsPX2hOnk2uNgXHK+oPHyLB7ofT3DZ6K6ZgNoNZQxnLt0ayqnWW02bA
b4z0OWf5Ijx89prbhIYZkHl2Y5s5aBFqXR3ayws2A6sf6qw7lRdhlqlNoMVb
M5Aadv4NGXZ/mwv+TXFuyQwU7y927bUvQM/3bPRv1M2Bk/XNd3bSWD80+yrV
9aE56BnpAnvT8/AIhTzrpQpzwNBKYqCeOg+zFU14G05agEXrIqiBrdf7DwVy
n2ctgOzMzn2gOAtpFyRbEpgtwSURykss4zPwNmXHNR1VS+BhJh6Z6zkDl5VX
tEdeWwLrpoGkhKfT8GiHoM2StxW42Htw78ivSai/1LheXGIFsouPclBiefP0
sJab46QV4L0dE24jOgklVF0DtxWtwR75zeizW+Mw0IbiYK2nNeh+eX7g4MVx
2BGVGu3/0hr8reA56xwzBg0+VqdS0NsA8sjTV6PAKCxYUWHtuGoD+Ki09Nvr
R+D6kZHcGHcbcEpRlVB0dgReErDj1XhhA7Y9qmjpCodhkNqf4uOjNoCm/o8+
ujQMP9nFiQzQ2gL6CkPurpohyBjLXp1x2RZ4kjwRTLIZgoYlpXKGrrbAas40
kJZqCD7/fLmFs9AWXAkyv/S7ZhD+WOu9NjdkC/wN68KdIwahDK1Z13NqOxDx
iopzXX4Qhlzc0raDduBbCjjryDUIu9TDhgSd7cBhG9XcrgODkNmB2WjzmR34
0NZ5q2t+ABrHP599O2AHrv+xEjPbGIBFr6VsvKkegFcqVIOUs9j97kvnupzc
AxChRFXwc3cAym7cdSN1fAB2BSeeUp4chGFH1/be5z0A2/GKQs0XB+EXIf/A
iL4HQCCZ107XYRCe0KQ7qHbIHqj3zMbGPx6EJk450XQy9qCN9jykw+5zLxOF
6b8+sAe5vRw8/VJDEPRqs+p/tQcMK5zkaG0IRvyYzWU76ACqzNQ3DmoOw55j
7rxTlxwABTGjvr5mGJ4SpSx5ZusASm5pR5ReGYFm2ukiVtkOYF9uir79zQh8
5cJffb4H8wnxkAdXRuG+ylj2NqkjYIl6/5SnZxQq2thz1Yo5Ao6kHocB0nGY
IGEXJKfhCIo5qaxpSsbhKJnNZIOtI/gg+/JV0L0J6JppnvU+zxF8p2Ap7jGf
hM8+GTB0HXUCG93vDGPmpuBGur6zhoAT0KXfN7mtPA1lzfW6e5WdwNUkXhbl
F9Pw2x/tmAF/J/Bhy+G6vd0MPCB4nXxq1QmU0CZQXlucheq/r5mYHnIGExH0
Dx9dnYMZbUqNc2edQYvXZ1KSx3NQxPiK77K+M6g/Wcx2SWUe+gvID9u5O4Mr
Z974FGbOw84duUvric6AZ+1HiOXKPDRJlPq52e4MpIrE9S4FLcBX9yS13Ged
AZdgVQFJxwLc4xcv3fnnDO5XlLyMoF6ESr9EaH1YXICN39iNCrVFSGgWsvsj
4QLIzlwqsYlchONxFzsDtFzAA/2PJ1ObF+G5uwJ8ZPYuoHzkCyXXziJs2uSd
PZjvArj0gtME9JYgdSP3lchGF8A6GHwjMWgJ6sWczTky6gKiRQzDBV4swWd6
nH9jt11A1PMB572PS3CDi93g6HFXsESWtLG7vARlv7PWEC66AivnFB+Bg8sw
ov7UCUZVV+Ar+owulW0Zfos84Z5m7goavZ/SygkvQw5dpm8nH7qC2+Ns3Ocu
L0O7MwwiWVmu4CfX6YtWN5ZhNZE+4XS1K0h7eo6JXHcZktfSEXO+uoI9HlJE
fXcZaoTTqJ1ddwXqsWFjBINlmKV9pCifyg2MOEjNP9dfhovshw/x8biBSe/k
OZNby1Bs9aBF0WU34OITYNmvtgwDqsnfC9xzA6Wnl/ROYeN3hpCdee3pBvwz
cpeVRJYhkyZJoHCyG7hVE+PqxrEMTdj+jpW/dgMW9PJ3Go8sw1dLv2UkPrqB
R/c5lq/8XIJ7lbuPqufdQNVjOrWTw0tQKWh7W5rMHZxqLzcwrl+C46c2y6GU
O+A4Mfjvre8SPLewQd+s4w7o3E3IDtzB8r+c6KDg6A6uMDWbXhJdgrRqy+dV
Ct2BQNmW28jUIpTzm3qqxegB3GujH9udX4QZEu5OOkIeQPFt8q1buwvw1zoV
1L3uAQyNP5LUtmH9uInY8J2HHmB8nS1n1RzrN6+FH72/5gH0KCOu9sbPw4PH
L/g5tHqCmyVJ7Y3js9DkU5Oq06QnaFGyfzH4YhY2hOqecPntCayWbW/9dJ+F
njsB5e7CXmAMzb4ROTYLV8Z6l/weewFiwHftfcUZeC3Nsiqg2gs8Cjq4hphn
4DON/ZCHX72AOtuBiwIr09CwhZsj9LA3CLEfNvmUOA27n3vqxrh5g+k/JrLN
81NQwISGKy7BG0imFnRPN03BSJa87/EvvUFVuXjPPHZ/vhL3MSZpyht8nP8Q
JHprCj5RNtZP2fcGpEGsft7CU3CfZIs3jdkHGL0gem7QTcFKl9MtGTd8wNeg
C0c8+ibhsQvlCVlWPoCyT7ZuvWYS2s8rG2YH+4Am3te8CTmT8OOT0fM52T7A
4BQVw+/QSch3x2k3950PeEX8euSH7SQMOXaw7ek3zPwV1p3ak3DqY0Zy/roP
cJU84uQLJiEIFTQppPIFUiXUrb/OT8IM8F7wBbcvSOxqlL/IMgl/bev9KZL3
BZfraQxHqSah9pu1zuK7vqD0PRNX+88JWGoTlP7K3Rd8GXnN4PltAlJzMVuU
JvoCm6P22uerJqD12EvRsmJfkHvuqRv5kwn4IVWetKLNF8z8nag3jZmAZzT6
uiqnfYFQVlBYgd8EDDhsk1X1xxcQjtLYaThOwNHmv9bvTviBWA2HjTaTCXjJ
N0myVtQPOKVQq9jdmoAp4nwU9ep+IMArQkJBdQL+INb1Ims/4Ka89Cnk6gRU
f66Z0xjiB76srDX/uTwBX96ff9D8xA+cTGLbCFOYgIdYfGTe1/iBh+Z3rHuu
TUCzb3SHP/T5gbog8+ADNyagkrZd6S+iH/C+8cT6hfoE5Ottv817yB+0aR21
otKZgFSa3P9uc/oDDYXk6CNmE3D1y8OCCGl/cLnVszfMdgI7H8dvvNP2ByK3
E2UeumPz9Vl6a8nOH7TLxeh9i56ABLW0rFNh/oD9uW74x/QJ6PZx8+r1J/5A
WDsCHXwxAfVUNVZ8qv0Bk19Es2bLBJTuKCYU9/iD5boH0KpvAv79YD5FQx4A
4i486Ksin4STis0RgC0A0AoWhp49Ogmb358WcpAIAFbFkb47rNh5ctVn4MnN
APA6uOlL1MVJGNY84N9tFQBs2nbMeGUnodVlMR7SoADgKLTge+z6JFRtTPgs
nBkADr8+SJdiOAkF4JqrSUUAcC+1PSlqPwnpkApr0ucAkPxGQ+hgwCT8IVvQ
0jIfAMroKfNUkyfht1oy25//AsCtFh/p2vxJ+Gl0bPTcyUAgvvvMl/PLJJRj
jRFq4Q4ElY407ySmJ+Gru9Ihd0UCwdEPJhpaWL+VMJx6PuZ6IHBSlRpkPzsF
dQZveq/5BQLJJNerxf5TsJX57+fQqEBg/lqSS/bRFJS4Xcx5Oi0Q0Phtn5Mq
nYIn+g91qJcGgpXKonu+M1Nw7GsTc+l0IPBMVfglrjINLb6IVjorPwSjt5ZD
/p6ZgR4fmDe2jwaBN1dU9UxnZ+H+U+PEnNNBwOMvkVT6wBwMfPhCREUgCHwe
5djd5ZyDUbIybhnKQaBBPJCB0WgOZpUZ7sn6B4Ha/YnH5wfmYHN2PnnQShBo
KW2Q9m6Yh0q+xPxzu0HgV3TL+92RefjxjqTy14PB4PMpfgf9nXn4jaEjkutM
MBjKOh/1SmgBLkSt0rbpBQNv/phc8icLkNpD9CT1h2BQ/r3Bac1+ESbo+NZU
fA0G06nk/6rDFyGjSOvde1PBwItto141ZxGeXtPNfrWP/b/CG/CpexEKm3qf
1RQNAasf84ZNBJeg7s2mC6k5IaDMfo/7wNQSHBag+gJehYD3heyVq1tL0IhK
23GhNgQEG5UGRFEtQ6vW2bJLAyFg1Phf1DJ23vjIHLo0QhMKyttPEqIDl2EO
780rHD6hQJDW1YB4dAUuLvhoTIaHgvcurzeiOFag4PPnhjnJoYDx3dzZBKEV
iPjIfDhehQItsr2DzDdX4Ah/ZTnHVCj4/WtpjDpyBZ5ZnmqaXAsFdVPHLAvS
VqBNEW13zl4o4LLpltx6tgJ3zlmtcjCEgfsl7BKajSuQSYCFm1M5DER/0fBo
+bkCDVeVRae0w4CpcdzpRpJVmF/sejnXOAz4WFBWhdGsQrELXfc4vcOAqpZJ
ijH3KtS6+DCVsyQMpMUnfeHRXoWxQguUZ46Hg5RYJaraglX4beM40zR7OKCM
KOG7VboKWd/Ic+UJhIMQaSWRF+9WYZFwhvwZpXDgkj2Tf+TTKmwXueF1xisc
3PQsuKKxvgqPbnqFT4eGg/ynz/55ba/C2+UFKXmEcLD/IXb0z79VOC9KUnam
OBwch1zxK3RrkFy8fPnMRDggC7VZGrqwBtW2JnamV8LBc+PgJl3xNZhUSU35
dCcckMY1n2ORXYNnJCzOnj0Wgd33mvZWVdYglDxpcFYxAlh4dHyeM12D3lIB
n8++jAAiDiYh9xLXoKqjR9LTqgjwte1TvH3qGjxV6HDn7PsIrN6WLZIz1+A7
BuO5M2MRwKDIuJM0fw3urMv/4aSLBBsM53ipq9ZgO49USy5LJCil+y7lVrsG
0+8JR3LyRYLzNt/pnjWsQcmPnIyclyMBKW9yXmLbGnQvILvA4RIJvo947uT1
r0Glsb0fTwIiActnE33Z4TXIxLBZzR4TCcLFIyPixtZg5cMZBfb8SEBpLFF3
c3YN/jR4b3B6IBKkHXug8GJjDb5PqjuTPRMJioWqUt0312ByZ8Ui20YkoPK+
1y/5aw2KXcp3ZTscBUr11kTf/16DLsfDYlhlosCf9F6eagoivKLqr5WlHAVm
SgXPblMS4bGH7idYdaJAvkyNkDoVEZYRLZ6xPIgC8akbs49piTCI28gm0ysK
yPao+r48SoRaBreFWMKiQCUVLW3HMSL80aFcd+pJFOBgrSWLZSLCZhL5oIyX
UYA+4lOT/QkiJEheunaqOgrcfPrCXe0UEQrn83072RMF5OYK9x6xEaFj4OHV
EweiQfvmjHvfWSKUryItS6eLBsIOeRm3uYnwKHHX4wRrNPA7mM1TxkOEr+8u
HzghHg342l9tqPEToT9huiPtcjSw7xTlTj9HhOodw/HM6tHgw4MN+trzREiU
+MjCbBkN3jXXSlNfJEL0oGUq1SUaJG2ATXZBIox7VlvIFBgNVGYc1pmEiPDC
sWJRpkfR4EzZ00vsIkS4f+3Zbkp+NHjy8o4MiSgRfgrIamAsiwbyAxOW/Zjt
1mKuM36MBnr3Ig8niROhRjO7Uf5gNCCXK1u3kSBC0bQyZ/H5aOBBvZYpJkmE
e/KDj26RxgAVpobo/EtEOMZoWzJHGwOCH7loaUkRYePyn0Y31hgw1eXQv4s5
PPnsYopkDGB0jauWlCFCG+u3v7kVY8C0dYFXJ2Z1oEL3VisGRPVMuWrJYvN7
fPSMknEMIKwGjnRhZli0l+h/EAPui7MbyssR4U4dqaqFTwzQvFa/9hzzSGLy
vV8RMaDvUNsfKkCEeTI1IUzPYkAujdDzZsxhR2+kF7yJAZdHPr05AYnQem7i
pURDDCiKUj9vjVmtxrnhw6cYACkvSpZhFoqn+Ko7HAN+lln5/sB83Cx9fn4h
BtjbvWvglyfCX5fO77lvxQBJr2XyO5iHaRAN5YFYcIDz88UgzPXTGpxpR2OB
wjV55ULMOVUzYrynY0HBO8W6DswhMe7Xqs7Hggu2dTNLmC3vHzZQlooF+a0e
Pw9eJkJViSyHAaVY8E32sxM75otHBIMtdWKB5NS5EWHM9JNNqdv3Y8EfGXE9
Ocw/K3SKwh1iQeovSpYrmAcjF+qZ/WKBzVyj5mXMdYbePYVRsaA7+FeZLOYn
ojRzkumxwG5wdEAcc9ChnJ22/Fgwdt288AJmizERar3yWOAY9JuaC7NKWSv7
YmMsGO04wHwCs0C4nqhnVyyo3HppfwjzUYMVpUOjsUB4+NDmJvY9m0L++ulL
sSA2++ylYcz9FPT2fNux4Jj6qXe1mGuGnz6sJo8Df9qYSh5hDgzpeD7IHge+
/24K1MBsdsegzupCHMhP6aU8j1n54vqXHek4QMOa0kyOmXaQYfuEbhzoudra
8gZbn+/FhVQvTOOAtG8bezDmbw+lT0s5xYGwv87lGpgzzxsr3omJA2U65pkz
WD3wBbxMetQcB2xOvFMiw0ytAwr5u+MAn1qjQztWT+t8PTXvxuLAdYO3ZjGY
3/b+mhraiQO8zabm1Jiv8lwROiUYD9Ymb4X/xep3eay6tEkmHgyV8bG0YE5I
ERS2vhYP2s3exAdjHiVnE6m+Hw84y96HkGF2ndkW1U2OBx3sB979xPZHQU6J
JGE3HoyttxQNYvsrJDaGncIkAdjvZui9xvbn7aW2CT2rBNCy7JZqh/mc4oGc
YvsE8Lzgga4Q5u59Lw4dnwQQAwd1X2P7ndXOkvNpcgIofXPdt0aYCCtVr5y9
3JYAEme4feawvIgo8JtJ/pwAnFsWnhZhNiB793TxawIIipfacMVMViPIlTCZ
ANTWc1spMKvzs3FP7CYAbnPtbTEsf+Ypd3j8BBJBZeJBv5cCRNhSRkJ7RzQR
hHiLSXlhzrl3eEtMOhF8fPu8VBmzfvmpllXlRJB23rRnHsuzz4ZyRgamiSAy
/OjXC5iLDispXbJJBHfVxcxIMYdVqF9gcEoEWqTnXvVheShPZfz7o38isEt2
tQ7EXFEZlCaTkQgS6DbMxrH8TDSO9mfOTQRUI5rPqjDbH0k23yxMBGLHT6Yk
Yua9ny/6sjIRkHjvBCtjzqBu/3KqJxE4fUbOtXxE+NCU5tAeJQGQZLOINvMS
oSEt03ofLQEEb1zryscs/e50/xtGAmDSXiWJwvyTVuiZ9VkCGDmmcFYHs1WN
lvwQIIDun4G861i+K5rf5a1UJIAr/0gUBzCfOWpGm6hGAIIFvksNmEfM3Uav
6RMAzF9pJGBWp0/3rHYjgGM3f9oDzOfrcoySfQkgT6sg7hzmQ5YvlByDCeDo
uQRuZszNdTUMfIkEIPmP+OY7dr6IW42VphUTAK9C+JFizMeOz6e5lBPAv/SB
V5mYifVE/5s1BHDuNVdNNObnx0luULYTgEpkCMkDzKwNZ5bcZwhgRiXnpBhm
/buPw8aXCGDSwOg8L+b0bWYupQ0CGO8XiGbBzChEY8T4hwAKGl6zkWOmzd3+
Vs6UBG4IL0YOcmF5KufszMKWBMo2vxp3YY4aWqULPpsEWGwEDN9jpjw2raol
lAS+TttffYOZJPhT44ZKErg56sQfhxmwKxvqaSQBgblezTDMvrVNvxt0k8D5
49KM/ph3N99KxJsmgSPpBxftMf8wyy2+4JcETAVWD2hjFiJlVU0JTgJCBe6i
apjtH6cu7EcmgedW1UJKmFf6os98Sk0CNOkudNKYZ5Xc021KsfGrpD+dxXxm
ZkO8920SYNehfXMas3GA7Vep+iRwK8Dt2UnMY1XGtIc7k4AfPQXHUcysOiMv
HbuTwFrr+sARzPobt1QG+5NAKeugFCXmfr7rIYUzSSCArWnlL9YfMLS2ctIt
JwEFhUK+35i17ss3uG9gf3/NS2Ab85dH4nuKf5KA09rtH+uY26k4HGeZkgHd
le3pacwHCzNo1NiSQZ7+ypsJzApXGV+Wn00G6YOvf49ibvKhmg8SSgbaUcIe
A5hJToQGL0skg83xx2+/YQYV/zi05JLBkwZjzV7MNas/73KqJgNy9rDwz5h3
Ihx2IzSSgVh2l/pHzBLcy6kbusngis4GcwfmsnsTPQ2mySD1ZxpJK+aXXR3K
hn7JQPzgj0/1mC/ynGvKD04G0QdqrtRhLvWLkl6LTAaVCntdNZhF+pbLxRKS
gRrtN9l3mCsErl/wTU0Gwql1A1X4eCEvC1qykoFc23r6W8zvRo5wHHmaDGZc
1WUqMaOoT8cyXieDnNMGs2V4vzUtEDNVmYwlOXvNG8wtUrEU/HXJoHWzO7UU
s1Limr9jczKIi1gtfI3P5+KNnar2ZHDIvqPkFWZV+VdO/7qSQYrYh6ISzJ/T
aFeU+pLB6NT0YDFmjXV7s7iRZPBi4ygV7l6lL2N9U8lAXpab7yVmnWzB22yL
yeDe4hP7IswDW/HdZsRkELrQ3/oCs/6NDZXin8mA00mFAvfoM42Wzb1ksH4o
0fg5ZsP9UlkZ0hRASy81UIh5Upv+bRBlCpjYy5PEPUfW+5yeIQVobxZKFGC2
0hc5c+dUCuAVHHubj3n5DSEzhyMFSIizXcJtd3iTYZEnBUQWlo8+w0w01o4T
vJACpEapvHE7VpdTeoimgCr2PBrcm3QMD5FUCjAedmh+itnd0nWPQj4F5MqR
e+PeQd9cbiilgANTkpy4vZnE15LVUgAT0XE6D/OfBykWo1op4NSj3te4A1u3
Js7eSQHJbZ9tcJOx6d6xNUoBZpmNErhDXN/2lpmngCDGeUbclJ+Y1PZsU0DG
Le7ZXMxRZz1aLzungBn5d+9wU/sMgEjPFNDv012AO65XsrrbPwW0oMRw3PTn
0oVPhKYAbmVjC9zJD3eKjKJTwPHPmfdwMw3pcRUmpgDCit9N3OlC7x4T01KA
kDHXJdynIk4yS2SnALnbGhK4sya8EvyepQA1o7b/zC45fLi1KAUssLKcw50X
Jx1M/SYFRFFYXMDNNZ+xr12VAhRfWUvhLpD77ZZZnwJSC9IlcfOl3F2fbkkB
D35cgLiLVmutznWmAG+ppzq4LyiwTjt1p4A7dAf/e9/STN+77/pTgGbYQSvc
Ipuj30jGUoCGfXgw7gpVOfVrMyngbtKBVNySeY/b4pdSAAz49Ax3ze4f+YH1
FGDtw/get6ymYc3pXymgLCVrAjd6jkQt9lOA8u2JH7gvk7CXlJClgsJqMQZ8
PZReTzyRpUsFvKPWN3H33qKRp2ZKBclMP1zz/qtX6ckR1lSQX9GQidtDJZXD
51wqWGiaXcX9fEYt951iKhDvGyTg9XL4RE2ehG8qqBbUIcHrMxUtXDkYnApI
4jWEcZ8xZ5zpi0wFTZwiJrilyxzPuqWlAvUvlc24bdR4n5WXpYKh2xr+eP1/
CkzOF1pKBY5AZhvfH3q8zYokG6mA1ugON76fZj+vz335lQou31nUwv3n1HUe
B/I0wKd95CXui5WkhSXsaeC39XMdfD/W3BVU9uNJA+/vmvrjViK7t6B2IQ20
fb3wHLfRzWreVek0YHIjcA93wpL983O6aUC3vzoV3++sCVnX9gzSQND9zGrc
zyU6FztM04AVU+MU7qZgbn5rpzTw+WHVBTwvfrCNviiMSQNbcz2luP3fH1b1
SEoDuZemu3FT2UouK2Wkgcet7zZwn6kmnJsvTAN6agFieP5oa6m85GpJAxXH
Kl7jll9eJA3sSAPXa+o7cF8MitAb+ZIGGH80zOCmKmujIIymARmvSCY83xrp
lYz/baUBpeh6N9yvXsy91d9PA8GcTgm4My+H0rwlSwenI1/m43Z3el9jR5cO
jEJrunEL9FxhHOZLB6v6Qlx4fp6ynrYVF0wHM2y9krgpSYOaE8TTAd/k8Wu4
p4WaHJSvpAMzpRcOuB8lwM6Ku+mgtuBgJe4wvgmOoybp4Gto8Cfcro3+HrZW
6aD/gN8YbhO9010f7NOx80ZsCbfGRj3XGbd0EP9k+TduEHHPx88nHVxL0abC
8/08x5+ewYfY+Ms/GHEf1JANiI9LB+3EJlHcPxdG+paT00GFfDfEPRXgI6CU
mQ6eHr+mgbuLmSU4NzcdzL0z1cdd97pmaL8wHXyR3rbA7UInJWbTlA6KE1LS
cRsXDka1tqWDUcO/ObjVoecUR1c62LCvKsEtO8B8yfdbOmCPXKrGfc6hKm5g
OB0cBqttuE9Q3p4TmUoHcZtgBDfFk18ycQvpgKJSdgX3D4lUwtJaOmgicdrA
PdklvqTwMx0cJHps/fe+Fn0wZy8d3K7QJ8XPu9q/rqm/SR4Bhf+vhTsPavqI
4gAOhkOOYC3HVBwOB+VIaVOiNUjHV+QqCAQxDhjtiDPSlkC03JZjimKjGA5B
FLu/hBAgDFoFOUUQFNChtECFtA2CUAZB41FAbJQAFctL+udnvju7b98/u/vP
Srzo6MslVjMRxgSu34y3QZd83OTbQCfwc2aELTqkgCV1cCFgrJfhhfZyVqjT
PyJg1ZHhjXa5nRCs3EoghuUYhLaKWF/h4UXgalABF71mtk6T503gdg6Nh34p
3BP2NIDAF0/pB9F/2b2s8g0l4MEIP4Lubz73r5RL4JfjxQJ0ayiTu8QjMFs0
nICu2yYZHD9MQOM5naKtf6MJp+ubVV+fSkeXrUntkx9bXc8h/wftfp49CsxJ
IXAllojQBYNhPXGZBKCQn4cWtrT7hp0iIGTknkdnSt26WCIC7iNtBJ0sLAGb
IgIbug+WoQUCWvviJQJGvFvl6CPc+B3jUgKGcnkV+oDX+I3OKgLtvLwa9N5N
u7fJrxEw7RPVo4PWttSfaSRQw+5uRHvPOTHj2ghMXPyjBe2pLLzG6SIwGZPY
gWZ2vHVj9ZLV89rkHtpZHlttfZ8Ag6/8FW2fO7x58U8CCzO3htDWiX4VY2ME
okOrH6DNefUOnVMEDk2mTaANvO1LK58TmGKYPEEvO+fanpknMJQ09QL9iq65
FKsh4GqrN49+ro625rwjoLKLeo1+9HDovIcRBUZZeovokW54z5pOQcHO6WX0
4JWr+RpLCjJ5pivo3sIPzMZsKWiYLXuHvnNcmHNnEwXml7/Ux/vYjUOvDCtd
KUh03EdD1/pHnTrNpOBx5GlDdJV7v17sdgq+5vxjjJZY7vg+dCcFaprYFH1h
qWr5Ez8K6n9KoqOze7PeLIRTUOrAt0Qfjt76t/AoBSmqIEf0/mAZn59MQUzb
SSd0GIuuCsmgoE9V6YwGPdWk5VkKpsOr3dGfqrhRC+cokBbkMNHuv3WOjZZQ
IPQMYKE3SqjhcjkF6Y1ubLRpbLIipoECVpPPZ2gNmzPA7KSgZvXNi1YZuva+
GaBgJsB6F1r5u/7djocURLQqfNBN3zbfDF5YrferOT90kRm/duR9MbBTs/3R
x+xWvlMHioFjEa/1bmax77osMUxouoLQzrtcLRjNYthQ+GEomsbteOD3Qgzm
poEcdHuq6mh6pASmDRTaPIVaT6u7K4GlE8+0uZWFfLkovxRqRfu0ecPJ7eqk
SCkYZBeHoM8qE3sOsMog5EcfresuRvbLjGTg08rQmqW8ILkvkMHbURetm2wU
ghWFDPbObdE6zSxumcEuB37e5hBdvw1EkeJyqJlw0lr2OEFotLYC2Pd01u+b
ONGcXAFqO934tB7BlMNoBQzU6jzftegv+rwS8vbo5m96bW/TWVcJ0ic6////
E+zf4qz1fw0Ph9A=
          "]]}, Annotation[#, "Charting`Private`Tag$7132#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwUV3c8198XtoukQilllBApI1TyvheJskIySvamzOy9994kK7soKquTpLL3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          "]]}, Annotation[#, "Charting`Private`Tag$7132#1"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"Population vs. Time\"", TraditionalForm], 
     PlotRange -> {{-6.*^-7, 6.*^-7}, {0., 1.0000000017594313`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Total\"", "\"P1\"", "\"P2\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.913733100767617*^9, {3.913733201386331*^9, 3.9137332176229095`*^9}, 
   3.913733463244337*^9, {3.9137335043586454`*^9, 3.913733526978387*^9}, 
   3.913733749515956*^9, 3.9137369338590794`*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"f512bddb-3d21-4239-afd2-3160705bb2bf"]
}, Open  ]]
},
WindowSize->{1141.5, 573.75},
WindowMargins->{{Automatic, -1309.5}, {Automatic, 85.5}},
FrontEndVersion->"13.3 for Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"242859f5-3742-43dd-bfac-8903c1dd729a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1137, 26, 67, "Input",ExpressionUUID->"15b68a68-948c-4125-b145-4dd6483c9a48"],
Cell[CellGroupData[{
Cell[1720, 50, 8995, 239, 619, "Input",ExpressionUUID->"f627302c-8394-461a-8f33-cf60a1f2bf02"],
Cell[10718, 291, 89337, 1558, 255, "Output",ExpressionUUID->"49fcf7d7-752b-4a2c-a745-7be338f7e704"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100092, 1854, 6238, 178, 528, "Input",ExpressionUUID->"8e7b013f-2da2-4569-9a5c-62d0cf16fbc0"],
Cell[106333, 2034, 66147, 1149, 247, "Output",ExpressionUUID->"f512bddb-3d21-4239-afd2-3160705bb2bf"]
}, Open  ]]
}
]
*)

