(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     11735,        285]
NotebookOptionsPosition[     10422,        256]
NotebookOutlinePosition[     10832,        272]
CellTagsIndexPosition[     10789,        269]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "This", " ", "Code", " ", "does", " ", "the", " ", "Analysis", " ", "for", 
   " ", "the", " ", "High", " ", "Harmonic", " ", 
   RowBox[{"Generation", ":", " ", 
    RowBox[{"Written", " ", "by", " ", "AbdAlGhaffar", " ", "Amer"}]}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.913467080984063*^9, 3.9134670900695033`*^9}, {
  3.9134671941714535`*^9, 3.913467202745454*^9}, {3.91346723521311*^9, 
  3.913467315308687*^9}, {3.9137153096048074`*^9, 
  3.9137153433186855`*^9}},ExpressionUUID->"b4da3f54-471a-4209-9da7-\
bb30ae1b89e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"The", " ", "parameters", " ", 
    RowBox[{"are", " ", ":"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"\[Alpha]", "=", 
     RowBox[{
      SubscriptBox["v", "0"], "/", 
      SubscriptBox["v", "Q"]}]}], ",", " ", 
    RowBox[{
    "feel", " ", "free", " ", "to", " ", "play", " ", "with", " ", "it", " ", 
     "and", " ", "try", " ", "different", " ", "values", " ", "and", " ", 
     "see", " ", "what", " ", "happens"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"\[Phi]", " ", "=", " ", 
    RowBox[{"w", " ", "t"}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"click", " ", "the"}], " ", "+", " ", 
    RowBox[{
    "to", " ", "the", " ", "right", " ", "of", " ", "the", " ", "slider", " ",
      "to", " ", "see", " ", "the", " ", "value", " ", "for", " ", 
     "\[Alpha]"}]}], " ", "*)"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.9134673650553274`*^9, 3.9134676235569754`*^9}, {
   3.913715811738676*^9, 3.913715848972268*^9}, {3.9137165391678085`*^9, 
   3.9137165450481977`*^9}, 
   3.9137169746266055`*^9},ExpressionUUID->"07f1f169-2407-401b-8f9d-\
9f4d16477192"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "-", 
        RowBox[{"Cos", "[", "\[Phi]", "]"}], "+", 
        RowBox[{"\[Alpha]", " ", "\[Phi]"}]}], ",", 
       RowBox[{
        RowBox[{"Sin", "[", "\[Phi]", "]"}], "+", "\[Alpha]"}], ",", " ", 
       RowBox[{"2", "*", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sin", "[", "\[Phi]", "]"}], "+", "\[Alpha]"}], ")"}], 
         "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"PlotLegends", "->", 
      RowBox[{"{", 
       RowBox[{
       "\"\<position\>\"", ",", "\"\<velocity\>\"", ",", " ", "\"\<KE\>\""}], 
       "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.913467643299464*^9, 3.913467688796395*^9}, {
   3.913467805127431*^9, 3.9134678716122694`*^9}, {3.913467952174312*^9, 
   3.91346796678831*^9}, {3.9134682677308865`*^9, 3.9134682701558867`*^9}, {
   3.9134686948526936`*^9, 3.9134687337326965`*^9}, 3.9134719326059246`*^9, {
   3.9134720327991505`*^9, 3.913472033950137*^9}, 3.913478837608198*^9, {
   3.9134792004343977`*^9, 3.9134792242051735`*^9}, 3.9137155261686163`*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"d8ecc919-6409-4fc3-b2b2-282f89d71137"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Alpha]$$ = -0.19999999999999996`, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`\[Alpha]$$], -1, 1}}, Typeset`size$$ = {
    447.19999999999993`, {107., 112.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Alpha]$$ = -1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[{1 - 
         Cos[$CellContext`\[Phi]] + $CellContext`\[Alpha]$$ $CellContext`\
\[Phi], Sin[$CellContext`\[Phi]] + $CellContext`\[Alpha]$$, 
         2 (Sin[$CellContext`\[Phi]] + $CellContext`\[Alpha]$$)^2}, \
{$CellContext`\[Phi], 0, 2 Pi}, 
        PlotLegends -> {"position", "velocity", "KE"}], 
      "Specifications" :> {{$CellContext`\[Alpha]$$, -1, 1}}, "Options" :> {},
       "DefaultOptions" :> {}],
     ImageSizeCache->{496., {160.13403309800196`, 165.86596690199804`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.913472037400135*^9, 3.9134720417746716`*^9}, 
   3.913478805846839*^9, {3.913478839496447*^9, 3.9134788536786385`*^9}, {
   3.913479208214767*^9, 3.9134792299584846`*^9}, 3.913715528270749*^9, {
   3.9137157692603273`*^9, 3.9137157957588053`*^9}, 3.913716487618183*^9, {
   3.9137169807367277`*^9, 3.91371698407161*^9}},
 CellLabel->"Out[7]=",ExpressionUUID->"86c9afcf-38a7-4238-adbf-d8f82a5fbcf2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
    "This", " ", "finds", " ", "the", " ", "zeros", " ", "of", " ", "the", 
     " ", "position", " ", "wrt", " ", 
     RowBox[{"\[Phi]", " ", "@", " ", "\[Alpha]"}]}], "=", 
    RowBox[{"-", "0.26"}]}], ";", " ", 
   RowBox[{
   "change", " ", "the", " ", "value", " ", "to", " ", "see", " ", "zeros", 
    " ", "of", " ", "\[Phi]", " ", "and", " ", "the", " ", "values", " ", 
    "of", " ", "the", " ", "KE"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.9134682219148073`*^9, 3.913468255175349*^9}, {
  3.913472146084671*^9, 3.9134721562706523`*^9}, {3.91371589830136*^9, 
  3.913715914193668*^9}, {3.913715963858758*^9, 
  3.9137160117926364`*^9}},ExpressionUUID->"1b312b23-490f-49e2-b5b2-\
f0687149b182"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Alpha]", " ", "=", " ", 
   RowBox[{"-", "0.26"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"Cos", "[", "\[Phi]", "]"}], "+", 
     RowBox[{"\[Alpha]", " ", "\[Phi]"}]}], "==", "0"}], ",", "\[Phi]", ",", 
   "Reals"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9134682145533996`*^9, 3.913468216445524*^9}, {
   3.9134682735830812`*^9, 3.9134682748970904`*^9}, {3.9134683202625914`*^9, 
   3.913468332437112*^9}, {3.9134684084025855`*^9, 3.9134684222790112`*^9}, {
   3.9134684827633867`*^9, 3.913468521914665*^9}, 3.9134789239186516`*^9, {
   3.9134789564098372`*^9, 3.913478978594165*^9}, 3.9134791652046614`*^9, {
   3.9137154021886044`*^9, 3.913715404669103*^9}, {3.9137154346986227`*^9, 
   3.9137154363002853`*^9}, {3.9137155678907294`*^9, 3.913715572878831*^9}, {
   3.9137158944436984`*^9, 3.9137158960188065`*^9}, {3.913715942648553*^9, 
   3.913715943608859*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"16179f38-4487-4250-bac7-7d5e87ba4acf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Phi]", "\[Rule]", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", "\[Rule]", "0.5324618132854674`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", "\[Rule]", "4.532878123137239`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.9134683382466917`*^9, {3.913468489371381*^9, 3.913468522899665*^9}, {
   3.9134789303222647`*^9, 3.913478979414793*^9}, {3.913479151925001*^9, 
   3.9134791661147118`*^9}, {3.913715407639017*^9, 3.913715437533583*^9}, 
   3.9137155742788954`*^9, {3.9137159348480453`*^9, 3.9137159455786934`*^9}},
 CellLabel->"Out[19]=",ExpressionUUID->"7dc26911-b8a6-4ee2-ac92-db1dd48a91d3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "This", " ", "evaluates", " ", "the", " ", "KE", " ", "in", " ", "units", 
   " ", "of", " ", 
   SubscriptBox["m", "e"], 
   RowBox[{
    SuperscriptBox[
     SubscriptBox["v", "Q"], "2"], "/", "2"}], " ", "for", " ", "the", " ", 
   "zeros", " ", "of", " ", "the", " ", "position", " ", "\[Phi]", " ", 
   "computed", " ", "in", " ", "the", " ", "previous", " ", "cell"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.9134721681847153`*^9, 3.913472337103077*^9}, {
  3.913715906373002*^9, 3.9137159240337863`*^9}, {3.9137160196882772`*^9, 
  3.913716040083151*^9}},ExpressionUUID->"b9e7678d-6ea9-49ef-9f8c-\
b2a617737fa6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "+", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "2"]}], "/.", 
  "\[VeryThinSpace]", "%"}]], "Input",
 CellChangeTimes->{{3.9134719902189035`*^9, 3.913471997339892*^9}, 
   3.913478936573025*^9, {3.9134791405890245`*^9, 3.9134791445769053`*^9}},
 NumberMarks->False,
 CellLabel->"In[20]:=",ExpressionUUID->"6e322a2b-87b0-4f0a-97aa-f595ed219c91"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.13520000000000001`", ",", "0.12266686689509232`", ",", 
   "3.094729392502352`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.9134685814869137`*^9, 3.9134719984158936`*^9, {3.9134789374802656`*^9, 
   3.913478982259859*^9}, {3.9134791462501736`*^9, 3.9134791692813835`*^9}, {
   3.913715421838891*^9, 3.913715440289901*^9}, 3.9137155782387094`*^9, {
   3.913715937178475*^9, 3.913715948348792*^9}},
 CellLabel->"Out[20]=",ExpressionUUID->"c4ae7864-e981-4e44-a5b5-70477daa5aa2"]
}, Open  ]]
},
WindowSize->{1141.5, 573.75},
WindowMargins->{{Automatic, -1284}, {Automatic, 92.25}},
FrontEndVersion->"13.3 for Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"bd42f883-8c37-49e4-a32c-a01c82711345"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 577, 12, 28, "Input",ExpressionUUID->"b4da3f54-471a-4209-9da7-bb30ae1b89e6"],
Cell[1138, 34, 1267, 30, 125, "Input",ExpressionUUID->"07f1f169-2407-401b-8f9d-9f4d16477192"],
Cell[CellGroupData[{
Cell[2430, 68, 1466, 35, 31, "Input",ExpressionUUID->"d8ecc919-6409-4fc3-b2b2-282f89d71137"],
Cell[3899, 105, 2227, 42, 345, "Output",ExpressionUUID->"86c9afcf-38a7-4238-adbf-d8f82a5fbcf2"]
}, Open  ]],
Cell[6141, 150, 780, 17, 28, "Input",ExpressionUUID->"1b312b23-490f-49e2-b5b2-f0687149b182"],
Cell[CellGroupData[{
Cell[6946, 171, 1063, 20, 48, "Input",ExpressionUUID->"16179f38-4487-4250-bac7-7d5e87ba4acf"],
Cell[8012, 193, 703, 15, 32, "Output",ExpressionUUID->"7dc26911-b8a6-4ee2-ac92-db1dd48a91d3"]
}, Open  ]],
Cell[8730, 211, 670, 15, 30, "Input",ExpressionUUID->"b9e7678d-6ea9-49ef-9f8c-b2a617737fa6"],
Cell[CellGroupData[{
Cell[9425, 230, 457, 11, 28, "Input",ExpressionUUID->"6e322a2b-87b0-4f0a-97aa-f595ed219c91"],
Cell[9885, 243, 521, 10, 32, "Output",ExpressionUUID->"c4ae7864-e981-4e44-a5b5-70477daa5aa2"]
}, Open  ]]
}
]
*)

