#include "ganglia.h"
#include "metric_typedefs.h"
#include <sys/systeminfo.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/swap.h>
#include <sys/types.h>

#include <sys/sysinfo.h>
#include <sys/sysmp.h>

#include <sys/sysget.h>
#include <unistd.h>

int multiplier;		/* Pagesize / 1024 (for memory calcs) */

/*  here come swagner's crappy modifications.  all bad code
 *  is mine...
 */
struct sysinfo systeminfostuff;
struct cpuinfo {
   long		idle;
  float		idlepct;
   long		user;
  float		userpct;
   long		kernel;
  float		kernelpct;
   long		wait;
  float		waitpct;
   long		swap;
  float		swappct;
   long		interrupt;
  float		interruptpct;
   long		total;
} cpuinfo;

static struct cpuinfo oldcpuinfo;
static struct cpuinfo diffcpuinfo;

int
recalculate_cpu_percentages( void )
{
    static long last_update;
/*    if ( (time ( NULL ) - last_update) < 30 )
       {
       return 0;
       }
*/
    if (sysmp(MP_SAGET, MPSA_SINFO, &systeminfostuff, sizeof(struct sysinfo)) == -1) 
    {
      perror("sysmp");
      return -1;
    }
    cpuinfo.idle = systeminfostuff.cpu[0];
    cpuinfo.user = systeminfostuff.cpu[1];
    cpuinfo.kernel = systeminfostuff.cpu[2];
    cpuinfo.wait = systeminfostuff.cpu[3];
    cpuinfo.swap = systeminfostuff.cpu[4];
    cpuinfo.interrupt = systeminfostuff.cpu[5];
    cpuinfo.total = cpuinfo.idle + cpuinfo.user + cpuinfo.kernel +
		    cpuinfo.wait + cpuinfo.swap + cpuinfo.interrupt;
    if (cpuinfo.total < cpuinfo.idle)
       {
       return 0;
       }

    diffcpuinfo.idle = cpuinfo.idle - oldcpuinfo.idle;
    diffcpuinfo.user = cpuinfo.user - oldcpuinfo.user;
    diffcpuinfo.kernel = cpuinfo.kernel - oldcpuinfo.kernel;
    diffcpuinfo.wait = cpuinfo.wait - oldcpuinfo.wait;
    diffcpuinfo.swap = cpuinfo.swap - oldcpuinfo.swap;
    diffcpuinfo.interrupt = cpuinfo.interrupt - oldcpuinfo.interrupt;
    diffcpuinfo.total = cpuinfo.total - oldcpuinfo.total;

    oldcpuinfo.idle = cpuinfo.idle;
    oldcpuinfo.user = cpuinfo.user;
    oldcpuinfo.kernel = cpuinfo.kernel;
    oldcpuinfo.wait = cpuinfo.wait;
    oldcpuinfo.swap = cpuinfo.swap;
    oldcpuinfo.interrupt = cpuinfo.interrupt;
    oldcpuinfo.total = cpuinfo.total;


    if (diffcpuinfo.total == 0)
       {
       /* head off that divide by zero */
       return 0;
       }
    cpuinfo.idlepct = (float)diffcpuinfo.idle / diffcpuinfo.total * 100;
    cpuinfo.userpct = (float)diffcpuinfo.user / diffcpuinfo.total * 100;
    cpuinfo.kernelpct = (float)diffcpuinfo.kernel / diffcpuinfo.total * 100;
    cpuinfo.waitpct = (float)diffcpuinfo.wait / diffcpuinfo.total * 100;
    cpuinfo.swappct = (float)diffcpuinfo.swap / diffcpuinfo.total * 100;
    cpuinfo.interruptpct = (float)diffcpuinfo.interrupt / diffcpuinfo.total;
    last_update = time ( NULL );
    return 1;
}

/*
 * This function is called only once by the gmond.  Use to 
 * initialize data structures, etc or just return SYNAPSE_SUCCESS;
 */
g_val_t
metric_init(void)
{
   g_val_t val;

   (void) recalculate_cpu_percentages();
   multiplier = getpagesize() / 1024;
   val.int32 = SYNAPSE_SUCCESS;
   return val;
}

/*
 * 
 */

g_val_t
cpu_num_func ( void )
{
   g_val_t val;

   val.uint16 = sysconf(_SC_NPROC_ONLN);
   return val;
}

g_val_t
cpu_speed_func ( void )
{
   g_val_t val;

   val.uint16 = 0;
   return val;
}

g_val_t
mem_total_func ( void )
{
   g_val_t val;
   sgt_cookie_t cookie;
   int mem[1];

   SGT_COOKIE_INIT(&cookie);
   SGT_COOKIE_SET_KSYM(&cookie, "physmem");
   sysget(SGT_KSYM, (char *)mem, sizeof(mem),
          SGT_READ, &cookie);
   val.uint32 = ( mem[0] * multiplier);
   return val;
}

g_val_t
swap_total_func ( void )
{
   g_val_t val;
   off_t swaptotal;

   swapctl(SC_GETSWAPTOT, &swaptotal);
   val.uint32 = swaptotal / 2;
/*   val.uint32 = 0; */
   return val;
}

g_val_t
boottime_func ( void )
{
   g_val_t val;

   val.uint32 = 0;
   return val;
}

g_val_t
sys_clock_func ( void )
{
   g_val_t val;

   val.uint32 = time(NULL);
   return val;
}

g_val_t
machine_type_func ( void )
{
   g_val_t val;
   long size;
   
   size = sysinfo(SI_MACHINE, val.str, MAX_G_STRING_SIZE);
   /* strncpy( val.str, "x86", MAX_G_STRING_SIZE ); */
   return val;
}

g_val_t
os_name_func ( void )
{
   g_val_t val;
   long size;
   
   size = sysinfo(SI_SYSNAME, val.str, MAX_G_STRING_SIZE);
   /* strncpy( val.str, "FreeBSD", MAX_G_STRING_SIZE ); */
   return val;
}        

g_val_t
os_release_func ( void )
{
   g_val_t val;
   long size;
   
   size = sysinfo(SI_RELEASE, val.str, MAX_G_STRING_SIZE);
   /* strncpy( val.str, "unknown", MAX_G_STRING_SIZE ); */
   return val;
}        

g_val_t
cpu_user_func ( void )
{
   g_val_t val;

   recalculate_cpu_percentages();
   val.f = cpuinfo.userpct;
   return val;
}

g_val_t
cpu_nice_func ( void )
{
   g_val_t val;

   val.f = 0.0;
   return val;
}

g_val_t 
cpu_system_func ( void )
{
   g_val_t val;

   recalculate_cpu_percentages();
   val.f = cpuinfo.kernelpct;
   return val;
}

g_val_t 
cpu_idle_func ( void )
{
   g_val_t val;

   recalculate_cpu_percentages();
   val.f = cpuinfo.idlepct;
   return val;
}

g_val_t 
cpu_aidle_func ( void )
{
   g_val_t val;
   
   val.f = 0.0;
   return val;
}

g_val_t
load_one_func ( void )
{
   g_val_t val;
   sgt_cookie_t cookie;
   int avenrun[3];

   SGT_COOKIE_INIT(&cookie);
   SGT_COOKIE_SET_KSYM(&cookie, "avenrun");
   sysget(SGT_KSYM, (char *)avenrun, sizeof(avenrun),
          SGT_READ, &cookie);
   val.f = ( (float) avenrun[0] ) / 1024.0;
   return val;
}

g_val_t
load_five_func ( void )
{
   g_val_t val;
   sgt_cookie_t cookie;
   int avenrun[3];

   SGT_COOKIE_INIT(&cookie);
   SGT_COOKIE_SET_KSYM(&cookie, "avenrun");
   sysget(SGT_KSYM, (char *)avenrun, sizeof(avenrun),
          SGT_READ, &cookie);
   val.f = ( (float) avenrun[1] ) / 1024.0;
   return val;
}

g_val_t
load_fifteen_func ( void )
{
   g_val_t val;
   sgt_cookie_t cookie;
   int avenrun[3];

   SGT_COOKIE_INIT(&cookie);
   SGT_COOKIE_SET_KSYM(&cookie, "avenrun");
   sysget(SGT_KSYM, (char *)avenrun, sizeof(avenrun),
          SGT_READ, &cookie);
   val.f = ( (float) avenrun[2] ) / 1024.0;
   return val;
}

g_val_t
proc_run_func( void )
{
   g_val_t val;

   val.uint32 = 0;
   return val;
}

g_val_t
proc_total_func ( void )
{
   g_val_t val;

   val.uint32 = 0;
   return val;
}

g_val_t
mem_free_func ( void )
{
   g_val_t val;
   sgt_cookie_t cookie;
   int mem[1];

   SGT_COOKIE_INIT(&cookie);
   SGT_COOKIE_SET_KSYM(&cookie, "freemem");
   sysget(SGT_KSYM, (char *)mem, sizeof(mem),
          SGT_READ, &cookie);
   val.uint32 = ( mem[0] * multiplier);
   return val;
}

g_val_t
mem_shared_func ( void )
{
   g_val_t val;

   val.uint32 = 0;
   return val;
}

g_val_t
mem_buffers_func ( void )
{
   g_val_t val;
   sgt_cookie_t cookie;
   int mem[1];

   SGT_COOKIE_INIT(&cookie);
   SGT_COOKIE_SET_KSYM(&cookie, "bufmem");
   sysget(SGT_KSYM, (char *)mem, sizeof(mem),
          SGT_READ, &cookie);
   val.uint32 = ( mem[0] * multiplier);
   return val;
}

g_val_t
mem_cached_func ( void )
{
   g_val_t val;

   val.uint32 = 0;
   return val;
}

g_val_t
swap_free_func ( void )
{
   g_val_t val;
   off_t swapfree;

   swapctl(SC_GETFREESWAP, &swapfree);
   val.uint32 = swapfree / 2;
   return val;
}
