#include "ganglia.h"
#include "metric_typedefs.h"
#include <unistd.h>
#include <sys/stat.h>
#include <sys/swap.h>
#include <sys/types.h>
#include <sys/utsname.h>
#include <sys/times.h>
#include <sys/dk.h>
#include <sys/pstat.h>

#include <sys/sysinfo.h>

#include <unistd.h>

int multiplier;		/* Pagesize / 1024 (for memory calcs) */
unsigned int boottime;
unsigned long physical_memory;
unsigned long clk_ticks;

/*  here come swagner's crappy modifications.  all bad code
 *  is mine...
 *
 *  plus some more crap from knobi1 to support HP-SUX :-)
 *
 *  All missing standard metrics are flagged "FIXME"
 */
struct cpuinfo {
  unsigned long	idle;
  unsigned long	user;
  unsigned long	system;
  unsigned long	nice;
  unsigned long	wait;
  unsigned long	total;
} cpuinfo;

struct dcpuinfo {
  long idle;
  float         idlepct;
  long user;
  float         userpct;
  long system;
  float         systempct;
  long nice;
  float         nicepct;
  long wait;
  float         waitpct;
  long total;
} ;


static struct cpuinfo oldcpuinfo;
static struct dcpuinfo diffcpuinfo;

int
recalculate_cpu_percentages( void )
{
   static long last_update;
   struct pst_dynamic psd;
    if ( (time ( NULL ) - last_update) < 10 )
       {
       return 0;
       }

  if (pstat_getdynamic(&psd, sizeof(psd), (size_t)1, 0) == -1) {
     return -1;
     }

    cpuinfo.user   = psd.psd_cpu_time[CP_USER];
    cpuinfo.idle   = psd.psd_cpu_time[CP_IDLE];
    cpuinfo.nice   = psd.psd_cpu_time[CP_NICE];
    cpuinfo.system = psd.psd_cpu_time[CP_SYS]+psd.psd_cpu_time[CP_SSYS]+psd.psd_cpu_time[CP_INTR];
    cpuinfo.wait   = psd.psd_cpu_time[CP_WAIT]+psd.psd_cpu_time[CP_SWAIT]+psd.psd_cpu_time[CP_BLOCK];

    cpuinfo.total = cpuinfo.idle + cpuinfo.user + cpuinfo.system +
		    cpuinfo.wait + cpuinfo.nice;

    diffcpuinfo.user = cpuinfo.user - oldcpuinfo.user;
    diffcpuinfo.idle = cpuinfo.idle - oldcpuinfo.idle;
    diffcpuinfo.nice = cpuinfo.nice - oldcpuinfo.nice;
    diffcpuinfo.system = cpuinfo.system - oldcpuinfo.system;
    diffcpuinfo.wait = cpuinfo.wait - oldcpuinfo.wait;
    diffcpuinfo.total = cpuinfo.total - oldcpuinfo.total;

    oldcpuinfo.user = cpuinfo.user;
    oldcpuinfo.idle = cpuinfo.idle;
    oldcpuinfo.nice = cpuinfo.nice;
    oldcpuinfo.system = cpuinfo.system;
    oldcpuinfo.wait = cpuinfo.wait;
    oldcpuinfo.total = cpuinfo.total;

    if ((diffcpuinfo.total  <= 0) ||
        (diffcpuinfo.user   < 0) ||
        (diffcpuinfo.idle   < 0) ||
        (diffcpuinfo.nice   < 0) ||
        (diffcpuinfo.wait   < 0) ||
        (diffcpuinfo.system < 0) )
       {
       /* one of the counters wrapped. Just leave the metric out this time */
       return 0;
       }
    diffcpuinfo.idlepct = (float)diffcpuinfo.idle / diffcpuinfo.total * 100;
    diffcpuinfo.userpct = (float)diffcpuinfo.user / diffcpuinfo.total * 100;
    diffcpuinfo.systempct = (float)diffcpuinfo.system / diffcpuinfo.total * 100;
    diffcpuinfo.nicepct = (float)diffcpuinfo.nice / diffcpuinfo.total * 100;
    diffcpuinfo.waitpct = (float)diffcpuinfo.wait / diffcpuinfo.total * 100;

    last_update = time ( NULL );
    return 1;
}

/*
 * This function is called only once by the gmond.  Use to 
 * initialize data structures, etc or just return SYNAPSE_SUCCESS;
 */
g_val_t
metric_init(void)
{
   struct pst_static pst;
   g_val_t val;

   clk_ticks = sysconf(_SC_CLK_TCK);
   (void) recalculate_cpu_percentages();

   if (pstat_getstatic(&pst, sizeof(pst), (size_t)1, 0) != -1) {
     physical_memory = pst.physical_memory;
     multiplier = pst.page_size / 1024;
     boottime = pst.boot_time;
     }
   else {
     physical_memory=0;
     multiplier = 4;
     boottime=0;
     }

   val.int32 = SYNAPSE_SUCCESS;
   return val;
}

/*
 * 
 */

g_val_t
cpu_num_func ( void )
{
   struct pst_dynamic psd;
   g_val_t val;

   if (pstat_getdynamic(&psd, sizeof(psd), (size_t)1, 0) != -1) {
     val.uint16 = psd.psd_proc_cnt;
     }
   else
     val.uint16 = 0;

   return val;
}

g_val_t
cpu_speed_func ( void )
{
   struct pst_processor psp;
   g_val_t val;

   if (pstat_getprocessor(&psp, sizeof(psp), (size_t)1, 0) != -1) {
     val.uint32 = (psp.psp_iticksperclktick*clk_ticks/1000000);
     }
   else
     val.uint32 = 0;

   return val;
}

g_val_t
mtu_func ( void )
{
   g_val_t val;

/* FIXME HPUX */
   val.uint32 = 1500;
   return val;
}

g_val_t
mem_total_func ( void )
{
   struct pst_static pst;
   g_val_t val;

   val.uint32 = physical_memory * multiplier;

   return val;
}

g_val_t
swap_total_func ( void )
{
   g_val_t val;
   off_t swaptotal;

/* FIXME HPUX
   swapctl(SC_GETSWAPTOT, &swaptotal);
   val.uint32 = swaptotal / 2;
*/
   val.uint32 = 0;
   return val;
}

g_val_t
boottime_func ( void )
{
   struct tms boot;
   g_val_t val;

   val.uint32 = boottime;

   return val;
}

g_val_t
sys_clock_func ( void )
{
   g_val_t val;

   val.uint32 = time(NULL);
   return val;
}

g_val_t
machine_type_func ( void )
{
   struct utsname bla;
   g_val_t val;
   long size;

   size = uname(&bla);
   strncpy( val.str, bla.machine , MAX_G_STRING_SIZE );
   return val;
}

g_val_t
os_name_func ( void )
{
   struct utsname bla;
   g_val_t val;
   long size;
   
   size = uname(&bla);
   strncpy( val.str, bla.sysname , MAX_G_STRING_SIZE );
   return val;
}        

g_val_t
os_release_func ( void )
{
   struct utsname bla;
   g_val_t val;
   long size;
   
   size = uname(&bla);
   strncpy( val.str, bla.release , MAX_G_STRING_SIZE );
   strcat ( val.str, "-");
   strncat( val.str, bla.version, MAX_G_STRING_SIZE );
   return val;
}        

g_val_t
cpu_user_func ( void )
{
   g_val_t val;

   recalculate_cpu_percentages();
   val.f = diffcpuinfo.userpct;
   return val;
}

g_val_t
cpu_nice_func ( void )
{
   g_val_t val;

   recalculate_cpu_percentages();
   val.f = diffcpuinfo.nicepct;
   return val;
}

g_val_t 
cpu_system_func ( void )
{
   g_val_t val;

   recalculate_cpu_percentages();
   val.f = diffcpuinfo.systempct+diffcpuinfo.waitpct;
   return val;
}

g_val_t 
cpu_idle_func ( void )
{
   g_val_t val;

   recalculate_cpu_percentages();
   val.f = diffcpuinfo.idlepct;
   return val;
}

g_val_t 
cpu_aidle_func ( void )
{
   g_val_t val;
   
/* FIXME HPUX */
   val.f = 0.0;
   return val;
}

g_val_t
load_one_func ( void )
{
   struct pst_dynamic psd;
   g_val_t val;

   if (pstat_getdynamic(&psd, sizeof(psd), (size_t)1, 0) != -1) {
     val.f = psd.psd_avg_1_min;
     }
   else
     val.f = 0;

   return val;
}

g_val_t
load_five_func ( void )
{
   struct pst_dynamic psd;
   g_val_t val;

   if (pstat_getdynamic(&psd, sizeof(psd), (size_t)1, 0) != -1) {
     val.f = psd.psd_avg_5_min;
     }
   else
     val.f = 0;

   return val;
}

g_val_t
load_fifteen_func ( void )
{
   struct pst_dynamic psd;
   g_val_t val;

   if (pstat_getdynamic(&psd, sizeof(psd), (size_t)1, 0) != -1) {
     val.f = psd.psd_avg_15_min;
     }
   else
     val.f = 0;

   return val;
}

g_val_t
proc_run_func( void )
{
   g_val_t val;
#define BURST ((size_t)20) 

   struct pst_status pst[BURST]; 
   int i, count , running=0 , allproc=0; 
   int idx = 0; /* index within the context */ 

   /* loop until count == 0, will occur all have been returned */ 
   while ((count=pstat_getproc(pst, sizeof(pst[0]),BURST,idx))>0) { 
        /* got count (max of BURST) this time.  process them */ 
        for (i = 0; i < count; i++) { 
           if((pst[i].pst_stat == PS_RUN) &&  /* running state */
              (pst[i].pst_ppid != 0) &&  /* not owned by kernel */
              !((pst[i].pst_ppid == 1) && (pst[i].pst_uid == 0))) /* not owned by init, uid=root */
              {
                running++;
                }
        } 
        allproc += count;

        /* 
         * now go back and do it again, using the next index after 
         * the current 'burst' 
         */ 
        idx = pst[count-1].pst_idx + 1; 
   } 


   val.uint32 = running;
   return val;
}

g_val_t
proc_total_func ( void )
{
   struct pst_dynamic psd;
   g_val_t val;

   if (pstat_getdynamic(&psd, sizeof(psd), (size_t)1, 0) != -1) {
     val.uint32 = psd.psd_activeprocs;
     }
   else
     val.uint32 = 0;

   return val;
}

g_val_t
mem_free_func ( void )
{
   struct pst_dynamic psd;
   g_val_t val;

   if (pstat_getdynamic(&psd, sizeof(psd), (size_t)1, 0) != -1) {
     val.uint32 = psd.psd_free * multiplier;
     }
   else
     val.uint32 = 0;

   return val;
}

g_val_t
mem_shared_func ( void )
{
   g_val_t val;

/* FIXME HPUX */
   val.uint32 = 0;
   return val;
}

g_val_t
mem_buffers_func ( void )
{
   g_val_t val;

/* FIXME HPUX */
   val.uint32 = 0;
   return val;
}

g_val_t
mem_cached_func ( void )
{
   struct pst_dynamic psd;
   g_val_t val;

   if (pstat_getdynamic(&psd, sizeof(psd), (size_t)1, 0) != -1) {
     val.uint32 = (physical_memory - psd.psd_free - psd.psd_rm) * multiplier;
     }
   else
     val.uint32 = 0;

   return val;
}

g_val_t
swap_free_func ( void )
{
   g_val_t val;
   off_t swapfree;

/* FIXME HPUX
   swapctl(SC_GETFREESWAP, &swapfree);
   val.uint32 = swapfree / 2;
*/
   val.uint32 = 0;
   return val;
}
