#ifndef NODE_DATA_T_H
#define NODE_DATA_T_H 1
#include <ganglia/hash.h>

typedef struct
   {
      uint32_t start_time;
      struct timeval timestamp;
      char   *hostname;
      char location[MAX_G_STRING_SIZE];         /* This node's physical location in the cluster "x,y,z" */
      hash_t *hashp;
      hash_t *user_hashp;
   }
node_data_t;   

#define MAX_VAL_LEN 256
#define MAX_TYPE_LEN  16
#define MAX_UNITS_LEN 16 
#define MAX_SLOPE_LEN 16
/* The size of an ethernet frame, minus some for the name/units. */
#define FRAMESIZE  1400

/* This is not the most efficient was to do this...  should malloc mem later */
typedef struct
   {
      char type[MAX_TYPE_LEN];
      char units[MAX_UNITS_LEN];
      struct timeval timestamp;
      unsigned int tmax;
      char slope[MAX_SLOPE_LEN];
      unsigned int valsize;
      char val[FRAMESIZE];
   }
metric_data_t;
#endif
