/*
  File autogenerated by gengetopt version 2.7.1
  generated with the following command:
  gengetopt --input cmdline.sh 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* Check for configure's getopt check result.  */
#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

#ifndef HAVE_STRDUP
#define strdup gengetopt_strdup
#endif /* HAVE_STRDUP */

#include "cmdline.h"


void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", PACKAGE, VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  The Ganglia Metric Client (gmetric) announces a metric\n"
  "  value to all Ganglia Monitoring Daemons (gmonds) that are listening\n"
  "  on the cluster multicast channel.\n"
  "\n"
  "Usage: %s [OPTIONS]...\n", PACKAGE);
  printf("   -h         --help                  Print help and exit\n");
  printf("   -V         --version               Print version and exit\n");
  printf("   -nSTRING   --name=STRING           Name of the metric\n");
  printf("   -vSTRING   --value=STRING          Value of the metric\n");
  printf("   -tSTRING   --type=STRING           Either string|int8|uint8|int16|uint16|int32|uint32|float|double\n");
  printf("   -uSTRING   --units=STRING          Unit of measure for the value e.g. Kilobytes, Celcius\n");
  printf("   -sSTRING   --slope=STRING          Either zero|positive|negative|both (default='both')\n");
  printf("   -xINT      --tmax=INT              The maximum time in seconds between gmetric calls (default=60)\n");
  printf("   -cSTRING   --mcast_channel=STRING  Multicast channel to send/receive on (default='239.2.11.71')\n");
  printf("   -pINT      --mcast_port=INT        Multicast port to send/receive on (default=8649)\n");
  printf("   -iSTRING   --mcast_if=STRING       Network interface to multicast on e.g. 'eth1' (default='kernel decides')\n");
  printf("   -lINT      --mcast_ttl=INT         Multicast Time-To-Live (TTL) (default=1)\n");
}


#ifndef HAVE_STRDUP
/* gengetopt_strdup(): automatically generated from strdup.c. */
/* strdup.c replacement of strdup, which is not standard */
static char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}
#endif /* HAVE_STRDUP */

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;	

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->name_given = 0 ;
  args_info->value_given = 0 ;
  args_info->type_given = 0 ;
  args_info->units_given = 0 ;
  args_info->slope_given = 0 ;
  args_info->tmax_given = 0 ;
  args_info->mcast_channel_given = 0 ;
  args_info->mcast_port_given = 0 ;
  args_info->mcast_if_given = 0 ;
  args_info->mcast_ttl_given = 0 ;
#define clear_args() { \
  args_info->name_arg = NULL; \
  args_info->value_arg = NULL; \
  args_info->type_arg = NULL; \
  args_info->units_arg = NULL; \
  args_info->slope_arg = strdup("both") ;\
  args_info->tmax_arg = 60 ;\
  args_info->mcast_channel_arg = strdup("239.2.11.71") ;\
  args_info->mcast_port_arg = 8649 ;\
  args_info->mcast_if_arg = strdup("kernel decides") ;\
  args_info->mcast_ttl_arg = 1 ;\
}

  clear_args();

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "name",	1, NULL, 'n' },
        { "value",	1, NULL, 'v' },
        { "type",	1, NULL, 't' },
        { "units",	1, NULL, 'u' },
        { "slope",	1, NULL, 's' },
        { "tmax",	1, NULL, 'x' },
        { "mcast_channel",	1, NULL, 'c' },
        { "mcast_port",	1, NULL, 'p' },
        { "mcast_if",	1, NULL, 'i' },
        { "mcast_ttl",	1, NULL, 'l' },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVn:v:t:u:s:x:c:p:i:l:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'n':	/* Name of the metric.  */
          if (args_info->name_given)
            {
              fprintf (stderr, "%s: `--name' (`-n') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->name_given = 1;
          args_info->name_arg = strdup (optarg);
          break;

        case 'v':	/* Value of the metric.  */
          if (args_info->value_given)
            {
              fprintf (stderr, "%s: `--value' (`-v') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->value_given = 1;
          args_info->value_arg = strdup (optarg);
          break;

        case 't':	/* Either string|int8|uint8|int16|uint16|int32|uint32|float|double.  */
          if (args_info->type_given)
            {
              fprintf (stderr, "%s: `--type' (`-t') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->type_given = 1;
          args_info->type_arg = strdup (optarg);
          break;

        case 'u':	/* Unit of measure for the value e.g. Kilobytes, Celcius.  */
          if (args_info->units_given)
            {
              fprintf (stderr, "%s: `--units' (`-u') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->units_given = 1;
          args_info->units_arg = strdup (optarg);
          break;

        case 's':	/* Either zero|positive|negative|both.  */
          if (args_info->slope_given)
            {
              fprintf (stderr, "%s: `--slope' (`-s') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->slope_given = 1;
          args_info->slope_arg = strdup (optarg);
          break;

        case 'x':	/* The maximum time in seconds between gmetric calls.  */
          if (args_info->tmax_given)
            {
              fprintf (stderr, "%s: `--tmax' (`-x') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->tmax_given = 1;
          args_info->tmax_arg = atoi (optarg);
          break;

        case 'c':	/* Multicast channel to send/receive on.  */
          if (args_info->mcast_channel_given)
            {
              fprintf (stderr, "%s: `--mcast_channel' (`-c') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->mcast_channel_given = 1;
          args_info->mcast_channel_arg = strdup (optarg);
          break;

        case 'p':	/* Multicast port to send/receive on.  */
          if (args_info->mcast_port_given)
            {
              fprintf (stderr, "%s: `--mcast_port' (`-p') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->mcast_port_given = 1;
          args_info->mcast_port_arg = atoi (optarg);
          break;

        case 'i':	/* Network interface to multicast on e.g. 'eth1'.  */
          if (args_info->mcast_if_given)
            {
              fprintf (stderr, "%s: `--mcast_if' (`-i') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->mcast_if_given = 1;
          args_info->mcast_if_arg = strdup (optarg);
          break;

        case 'l':	/* Multicast Time-To-Live (TTL).  */
          if (args_info->mcast_ttl_given)
            {
              fprintf (stderr, "%s: `--mcast_ttl' (`-l') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->mcast_ttl_given = 1;
          args_info->mcast_ttl_arg = atoi (optarg);
          break;


        case 0:	/* Long option with no short option */

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */

  if (! args_info->name_given)
    {
      fprintf (stderr, "%s: '--name' ('-n') option required\n", PACKAGE);
      missing_required_options = 1;
    }
  
  if (! args_info->value_given)
    {
      fprintf (stderr, "%s: '--value' ('-v') option required\n", PACKAGE);
      missing_required_options = 1;
    }
  
  if (! args_info->type_given)
    {
      fprintf (stderr, "%s: '--type' ('-t') option required\n", PACKAGE);
      missing_required_options = 1;
    }
  
  if ( missing_required_options )
    exit (EXIT_FAILURE);

  return 0;
}
